import React, {Component} from 'react';
import {View, Text, Image} from 'react-native';
import AsyncStorage from '@react-native-community/async-storage';
import {connect} from 'react-redux';
// import RtcEngine from 'react-native-agora';
import Touch from '../components/Touch';
import PhoneModal from '../components/PhoneModal';
import VerifyCodeModal from '../components/VerifyCodeModal';
import QRCode from 'react-native-qrcode-svg';
import OrderDetailsModal from '../components/OrderDetailsModal';
import TipsModal from '../components/TipsModal';
import LoadingModal from '../components/LoadingModal';
import delay from '../utils/delay';
import Speech from '../utils/Speech';
import WxFacepay from '../utils/WxFacepay';
import Smilepay from '../utils/Smilepay';
import phone from '../assets/Vertical/phone.png';
import {onTalkCall, leaveTalkCall} from '../utils/agora';
import Toast from '../components/Toast';
import Screensaver from '../components/Screensaver';
import {width, setSpText, scaleSize} from '../utils/screen';
import {qrHost} from '../utils/config';
import Icons from 'react-native-vector-icons/MaterialIcons';
import AutoClick from '../utils/AutoClick';
import validity from '../utils/validity';

@connect(({admin}) => ({admin}))
class FacePage extends Component {
  state = {
    phoneModal: false, // 显示输入电话号码弹窗
    verifyCodeModal: false, // 显示输入验证码弹窗
    orderDetailsModal: false, // 显示订单详情弹窗
    goodsArr: [],
    talkCall: 2, // 0请求通话，1通话中，2，已挂断通话，待机状态
    contact: '',
    storeName: '',
    customerPhone: '',
    current: 1,
    tip: '',
    tipsModal: false,
    faceType: 'wxpay',
    sleep: true,
    loadingModal: false,
    qrCode: '',
    goTipsModal: false,
    type: '',
    code: 1,
    setting: false,
  };

  phone = ''; // 监听用户输入手机

  async componentWillMount() {
    this.storeKey = await AsyncStorage.getItem('KEY');
    let contact = await AsyncStorage.getItem('CONTACT');
    let storeName = await AsyncStorage.getItem('NAME');
    this.setState({contact, storeName});
    if (!this.init) {
      this.init = await WxFacepay.initialize(10000);
      if (!this.init) {
        // 微信刷脸失败，启动支付宝刷脸
        this.init = true;
        this.setState({faceType: 'alipay'});
      }
    }
    const setting = await AutoClick.isSettingsOn();
    if (!setting) this.setState({setting: true}); // 展示按钮
    AutoClick.on('wxpayfaceRegister', async () => {
      await AutoClick.clickBackKey();
      if (this.faceBusy) return;
      this.faceBusy = true;
      await this.wechatFace(); // 点击开通重新调用
      this.faceBusy = false;
    });
    // 监听微信输入手机号事件
    AutoClick.on('AccessibilityClick', ({text}) => {
      if (!text) return;
      const match = /^\[(.+)]$/.exec(text);
      if (!match) return;
      text = match[1];
      if (text === '删除')
        this.phone = this.phone.substr(0, this.phone.length - 1);
      else if (/^\d$/.test(text)) this.phone += text;
      if (this.phone.length > 11) this.phone = this.phone.substr(-11);
      clearTimeout(this.clearPhoneTimeout); // 输入号码超过1分钟，自动清除号码，防止绑定错误号码
      this.clearPhoneTimeout = setTimeout(() => {
        this.phone = '';
      }, 60000);
    });
  }

  setting = async () => {
    await AutoClick.goSetting(); // 按钮跳转设置
  };

  async componentDidMount() {
    this.listen();
  }

  onSubmit = async _phone => {
    const res = await this.props.dispatch({
      type: 'store/sendsms',
      phone: _phone,
      faceType: this.state.faceType,
    });
    if (res.code === 1) {
      if (/^\d+$/.test(res.msg)) {
        Speech.speak(res.msg.split('').join(' '));
      } else {
        Speech.speak('请输入验证码');
      }
      this.phone = _phone;
      this.setState({
        loadingModal: false,
        phoneModal: false,
        verifyCodeModal: true,
      });
    } else {
      Speech.speak(res.msg);
    }
  };

  onCodeSubmit = async code => {
    const res = await this.props.dispatch({
      type: 'store/verifysms',
      code,
      phone: this.phone,
      userId: this.userId,
      faceType: this.state.faceType,
    });
    if (res.code === 1) {
      this.setState({
        verifyCodeModal: false,
      });
      this.loading(true);
      const ret = await this.props.dispatch({
        type: 'store/wxdoor',
        userId: res.data,
      });
      this.loading(false);
      this.handleDoorLogin(ret);
    } else {
      Speech.speak(res.msg);
    }
  };

  handleOrderClose = () => {
    this.setState({
      orderDetailsModal: false,
    });
  };

  listen = async () => {
    try {
      while (!window.socket) {
        await delay(1000);
      }
      if (!window.socket.hasListeners('doorLogin')) {
        // 扫码验证成功
        window.socket.on('doorLogin', this.handleDoorLogin);
      }
      if (!window.socket.hasListeners('doorOpen')) {
        // 按钮开门事件
        window.socket.on('doorOpen', this.doorOpen);
      }
      if (!window.socket.hasListeners('scale')) {
        // 重力感应变化
        window.socket.on('scale', this.handleScaleChange);
      }
      if (!window.socket.hasListeners('talkCall')) {
        // 语音通话中
        window.socket.on('talkCall', this.handleTalkCall);
      }
      if (!window.socket.hasListeners('talkLeave')) {
        // 断开语音通话
        window.socket.on('talkLeave', this.leaveC);
      }
    } catch (e) {
      console.log(e);
    }
  };

  doorOpen = ({action, sense}) => {
    if (action) this.action = action;
    if (!this.sense && sense) this.sense = sense;
    if (action === '进店') this.action = 'leave';
    else if (action === '出店') this.action = 'enter';
    this.loading(false);
    // 即拿迷你店，唤醒屏幕时间为1分钟
    this.sense ? this.wakeUp(60000) : this.wakeUp();
    if (this.sense) {
      // 进门自动调起刷脸
      if (this.action === 'enter') this.face();
      else if (this.action === 'leave') {
        // 出门身份识别提示
        Speech.speak('正在进行安全检查');
        this.loading(true, 30000);
      }
    }
  };

  handleTalkCall = async () => {
    try {
      // 加入语音通话
      clearInterval(this.noTalkCall);
      clearInterval(this.callTimeout);
      const {data} = await this.props.dispatch({
        type: 'agora/agora',
      });
      await onTalkCall(data);
      await this.setState({
        talkCall: 1,
      });
    } catch (e) {
      console.log(e);
    }
  };

  leaveC = async () => {
    try {
      clearInterval(this.noTalkCall);
      clearInterval(this.callTimeout);
      await leaveTalkCall();
      // if (this.engine) {
      //   await this.engine.leaveChannel();
      // }
      await this.props.dispatch({
        type: 'agora/talkLeave',
      });
      this.setState({
        talkCall: 2,
      });
    } catch (e) {
      console.log(e);
    }
  };

  face = () => {
    this.state.faceType === 'wxpay' ? this.wechatFace() : this.smileFace();
  };

  // device 代表当前打开的门
  handleScaleChange = async ({count}) => {
    if (count === -1) {
      // 重力感应开始识别
      this.face();
      clearTimeout(this.wakeUpTimeout);
      this.setState({sleep: false});
    } else if (count === 0) {
      // 重力感应归零
      this.leaveC();
      this.setState({
        orderDetailsModal: false,
        phoneModal: false,
        verifyCodeModal: false,
        current: 1,
        tipsModal: false,
        goTipsModal: false,
        loadingModal: false,
        sleep: true,
        tip: '',
      });
    }
  };

  handleDoorLogin = async ret => {
    this.setState({
      type: ret.type,
      code: ret.code,
    });
    if (ret) {
      if (ret.code < 0 || ret.code === 401) {
        // 未授权，提示用户扫码验证
        let tipText = ret.msg;
        // 判断扣款方式使用支付分还是代扣
        this.payscoreEnable = !!ret.payscoreEnable;
        if (this.payscoreEnable && ret.code === -10 && this.sense) {
          Speech.speak('正在开通支付分，请看向屏幕');
        } else {
          Speech.speak(tipText);
        }
        this.userId = ret.userId;
        if (ret.code === 401) {
          // 需要验证手机号
          this.setState({
            phoneModal: true,
            loadingModal: false,
          });
          return;
        }
        if (ret.code === -10 && this.sense) {
          // 无感设备
          if (WxFacepay.getUserPayScoreStatus && this.payscoreEnable) {
            this.openPayScore(ret.action);
          } else {
            this.setQrcode({action: ret.action, tip: tipText, qrcode: true}); // 扫码开通免密支付
          }
          return;
        }
        // else if (ret.orders && ret.orders.length > 0) {
        //   // 有购物订单
        //   let goodsArr = [];
        //   ret.orders.map(v1 => {
        //     v1.goods.map(v2 => {
        //       goodsArr.push(v2);
        //     });
        //   });
        //   this.setState({
        //     orderDetailsModal: true,
        //     loadingModal: false,
        //     goodsArr,
        //     customerPhone: ret.phone || '0000',
        //     current: 1,
        //   });
        // }
        if (ret.action && !/您没有进店信息/.test(tipText)) {
          this.setQrcode({action: ret.action, tip: tipText});
        } else {
          this.setState({
            tip: tipText,
            tipsModal: true,
            loadingModal: false,
            qrCode: null,
          });
        }
      } else if (ret.msg) {
        let tipText = ret.msg.replace(/扫码/g, '人脸识别');
        Speech.speak(tipText);
        if (ret.code !== 1) {
          this.setState({tip: tipText, tipsModal: true, loadingModal: false});
        } else if (this.sense) this.setState({loadingModal: false});
      }
    } else {
      Speech.speak('正在重新识别，请靠中间站稳');
    }
  };

  setQrcode = ({action, tip, qrcode}) => {
    const state = {
      qrCode: `${qrHost}/#/store-${action || 'leave'}-${
        this.sense ? 's' : 'j'
      }${this.storeKey}`,
    };
    if (tip) {
      state.tip = tip;
      if (qrcode) {
        state.tipsModal = false;
        state.goTipsModal = true;
      } else state.tipsModal = true;
      state.loadingModal = false;
    }
    this.setState(state);
  };

  authinfo = async () => {
    const rawdata = await WxFacepay.rawdata();
    const {data} = await this.props.dispatch({
      type: 'goods/faceinfo',
      rawdata,
    });
    return data;
  };

  // 微信人脸身份识别
  wechatFace = async () => {
    const {orderDetailsModal, tipsModal} = this.state;
    if (orderDetailsModal || tipsModal) {
      // 出现订单弹窗，不做人脸识别
      return;
    }
    const tipText = '正在人脸识别，请看向屏幕，靠中间站稳';
    Speech.speak(tipText);
    // this.setState({tip: tipText, tipsModal: true});
    let auth = (await this.authinfo()) || {};
    if (
      auth.return_code === 'SUCCESS' ||
      (auth.code === 1 && auth.data.bizCode === '0000')
    ) {
      if (auth.data) {
        auth = auth.data;
      }
      const params = {
        appid: auth.appid || auth.subAppId,
        mch_id: auth.mch_id || auth.subMchId,
        store_id: this.storeKey,
        authinfo: auth.authinfo || auth.authInfo,
        face_authtype: 'FACEID-ONCE',
        ask_unionid: 1,
      };
      let res = (await WxFacepay.faceinfo(params)) || {};
      if (!res.openid && !AutoClick.enable) {
        // 返回错误自动重新识别
        res = (await WxFacepay.faceinfo(params)) || {};
      }
      if (window.socket) {
        // 返回结果，立即重新连接socket
        window.socket.connect();
      }
      if (!res.openid) {
        // 返回错误出现二维码扫码
        this.goTips();
        return;
      }
      if (res.sub_openid) {
        res.openid = res.sub_openid;
      }
      this.faceinfo = {...res};
      await this.wxdoor();
    }
  };

  wxdoor = async () => {
    this.loading(true);
    const action = {
      type: 'store/wxdoor',
      openid: this.faceinfo.openid,
      wxtoken: this.faceinfo.token,
      nickname: this.faceinfo.nickname,
    };
    if (validity.phone.test(this.phone)) action.phone = this.phone;
    if (this.sense) action.sense = true;
    const ret = await this.props.dispatch(action);
    this.phone = '';
    this.loading(false);
    this.handleDoorLogin(ret);
  };

  // 刷脸开通支付分
  openPayScore = async action => {
    const {orderId, code} = await this.getPayScoreStatus();
    if (orderId && code) {
      const {data} = await this.props.dispatch({
        type: 'goods/payscoreCheck',
        userId: this.userId,
        orderId,
        code,
      });
      if (data.code === 1) {
        await this.wxdoor();
      } else {
        const tipText = '请扫码开通支付分';
        Speech.speak(tipText);
        this.setQrcode({action, tip: tipText, qrcode: true}); // 扫码开通支付分
      }
    } else {
      const tipText = '请扫码开通支付分';
      Speech.speak(tipText);
      this.setQrcode({action, tip: tipText, qrcode: true}); // 扫码开通支付分
    }
  };

  // 刷脸查询用户支付分状态
  getPayScoreStatus = async () => {
    const {orderDetailsModal, tipsModal} = this.state;
    if (orderDetailsModal || tipsModal) {
      // 出现订单弹窗，不做人脸识别
      return;
    }
    const data = await this.payscoreinfo();
    if (data.code === 1) {
      const out_trade_no = data.data.orderId;
      const payscore_out_request_no = data.data.authorizationCode;
      const payscore_service_id = data.data.payscoreId;
      let auth = (await this.payscoreAuthinfo()) || {};
      if (
        auth.return_code === 'SUCCESS' ||
        (auth.code === 1 && auth.data.bizCode === '0000')
      ) {
        if (auth.data) {
          auth = auth.data;
        }
        const params = {
          appid: auth.appid || auth.subAppId,
          mch_id: auth.mch_id || auth.subMchId,
          out_trade_no,
          authinfo: auth.authinfo || auth.authInfo,
          payscore_out_request_no,
          payscore_service_id,
          // ask_unionid: 1,
        };
        WxFacepay.getUserPayScoreStatus(params);
        return {orderId: out_trade_no, code: payscore_out_request_no};
      }
    }
  };

  // 获取用户支付分状态
  payscoreinfo = async () => {
    const {data} = await this.props.dispatch({
      type: 'goods/payscoreinfo',
    });
    return data;
  };

  // 获取刷脸支付调用凭证
  payscoreAuthinfo = async () => {
    const rawdata = await WxFacepay.rawdata();
    const {data} = await this.props.dispatch({
      type: 'goods/wxauthinfo',
      rawdata,
    });
    return data;
  };

  alipayinfo = async () => {
    const {data} = await this.props.dispatch({type: 'goods/alipayinfo'});
    this.alipayInfo = await Smilepay.init(data);
    if (this.alipayInfo.code === '1000')
      this.alipayInfo.metaInfo = JSON.parse(this.alipayInfo.metaInfo);
    return this.alipayInfo;
  };

  smileFace = async () => {
    const {orderDetailsModal, tipsModal} = this.state;
    if (orderDetailsModal || tipsModal) {
      return;
    } // 出现订单弹窗，不做人脸识别
    const tipText = '正在人脸识别，请看向屏幕，靠中间站稳';
    Speech.speak(tipText);
    await this.alipayinfo();
    if (!this.alipayInfo || !this.alipayInfo.metaInfo) return;
    const {data} = await this.props.dispatch({
      type: 'goods/smilepay',
      service_id: 'auth',
      zimmetainfo: this.alipayInfo.metaInfo,
    });
    if (data.code === 1) {
      const res = await Smilepay.verify(JSON.parse(data.data));
      if (res.code !== '1000') {
        Toast.show(res.msg);
        this.goTips();
        return;
      }
      this.loading(true);
      const action = {
        type: 'store/wxdoor',
        alipayUid: res.uid,
      };
      if (this.sense) action.sense = true;
      const ret = await this.props.dispatch(action);
      this.loading(false);
      this.handleDoorLogin(ret);
    }
  };

  loading = (flag, timeout) => {
    this.setState({
      loadingModal: flag,
    });
    if (flag && timeout) {
      // 自动关闭加载界面
      this.wakeUp(timeout);
      clearTimeout(this.loadingTimeout);
      this.loadingTimeout = setTimeout(() => {
        this.setState({
          loadingModal: false,
        });
      }, timeout);
    }
  };

  // 语音通话请求
  onCall = async () => {
    await this.setState({
      tipsModal: false,
      goTipsModal: false,
      type: '',
    });
    const {talkCall} = this.state;
    if (talkCall === 2) {
      Speech.speak('正在接通中请稍候');
      this.talkCall();
      clearInterval(this.noTalkCall);
      this.noTalkCall = setInterval(() => this.talkCall(), 10000);
      this.setState({
        talkCall: 0,
      });
      clearInterval(this.callTimeout);
      this.callTimeout = setTimeout(() => {
        clearInterval(this.noTalkCall);
        this.setState({
          talkCall: 2,
        });
      }, 30000);
    }
  };

  talkCall = () => {
    this.props.dispatch({
      type: 'agora/talkCall',
    });
  };

  dropUp = () => {
    let {current} = this.state;
    if (current > 1) {
      this.setState({
        current: --current,
      });
    }
  };

  dropDown = goodsLength => {
    let {current} = this.state;
    if (current < goodsLength) {
      this.setState({
        current: ++current,
      });
    }
  };

  wakeUp = (timeout = 18888) => {
    this.setState({sleep: false, tipsModal: false, goTipsModal: false});
    clearTimeout(this.wakeUpTimeout);
    this.wakeUpTimeout = setTimeout(() => {
      this.setState({sleep: true, tipsModal: false, goTipsModal: false});
    }, timeout);
  };

  goTips = async () => {
    if (this.payscoreEnable) {
      await this.setState({tipsModal: false});
      Speech.speak('正在开通支付分，请看向屏幕');
      this.openPayScore(this.action);
    } else {
      Speech.speak('请扫码开门');
      this.setQrcode({action: this.action, tip: '请扫码开门', qrcode: true});
    }
  };

  goToo = async () => {
    await this.setState({tipsModal: false, goTipsModal: false, type: ''});
    window.socket.emit('jokerOpen', true, 'enter');
  };

  render() {
    const {
      verifyCodeModal,
      phoneModal,
      orderDetailsModal,
      goodsArr,
      talkCall,
      storeName,
      contact,
      customerPhone,
      current,
      tip,
      tipsModal,
      sleep,
      faceType,
      loadingModal,
      qrCode,
      goTipsModal,
      type,
      code,
    } = this.state;
    let flag = '';
    if (type === 'over' && (code === -9 || code === -10)) {
      flag = '我已付款';
    } else if (type === 'loss' && (code === -9 || code === -10)) {
      flag = '确认出店';
    } else {
      flag = '';
    }
    let {dispatch, admin} = this.props;
    if (faceType === 'alipay') {
      styles.header = {...styles.header, backgroundColor: '#1b7dc7'};
      styles.btnCome = {...styles.btnCome, backgroundColor: '#1b7dc7'};
      styles.footer = {...styles.footer, backgroundColor: '#1b7dc7'};
      styles.onCall = {...styles.onCall, backgroundColor: '#1b7dc7'};
    }
    return sleep ? (
      <Screensaver onPress={this.wakeUp} />
    ) : (
      <View style={styles.content}>
        <PhoneModal
          visible={phoneModal}
          transparent
          onCall={() => this.setState({phoneModal: false})}
          onSubmit={this.onSubmit}
          faceType={faceType}
        />
        <VerifyCodeModal
          visible={verifyCodeModal}
          transparent
          onCall={() => this.setState({verifyCodeModal: false})}
          onSubmit={this.onCodeSubmit}
          faceType={faceType}
        />
        <OrderDetailsModal
          visible={orderDetailsModal}
          transparent
          maskClosable
          onClose={this.handleOrderClose}
          onRequestClose={this.handleOrderClose}
          onCall={this.onCall}
          dropUp={this.dropUp}
          dropDown={this.dropDown}
          goodsArr={goodsArr}
          dispatch={dispatch}
          talkCall={talkCall}
          customerPhone={customerPhone}
          current={current}
          faceType={faceType}
        />
        <TipsModal
          visible={tipsModal}
          transparent
          title={'开门失败'}
          tip={tip}
          leftText={'回店核对'}
          contentText={flag}
          rightText={'呼叫客服'}
          leftTouch={this.goToo}
          contentTouch={flag === '' ? '' : this.goTips}
          rightTouch={this.onCall}
          onMaskPress={() => this.setState({tipsModal: false})}
          faceType={faceType}
        />
        <TipsModal
          visible={goTipsModal}
          transparent
          title="温馨提示"
          qrCode={qrCode}
          tip={tip}
          onMaskPress={() => this.setState({goTipsModal: false})}
          faceType={faceType}
        />
        <LoadingModal transparent visible={loadingModal} />
        <View style={styles.header}>
          <View style={styles.title}>
            <View style={styles.left}>
              <Image
                source={require('../assets/logo2.png')}
                style={styles.imgs}
              />
              <Text style={styles.text}>{storeName}</Text>
            </View>
            <View style={styles.right}>
              <Text style={styles.text}>{contact}</Text>
              <Image style={styles.phone} source={phone} />
            </View>
          </View>
          <View style={styles.headline}>
            <Text style={styles.headTitle}>刷脸开门系统</Text>
          </View>
        </View>
        <View style={styles.face}>
          <View style={styles.faceRecogn}>
            <Touch style={styles.faceGif} onPress={this.face} feedback={false}>
              <Image
                source={require('../assets/Vertical/face.gif')}
                style={{flex: 1, width}}
              />
            </Touch>
          </View>
          {!admin.autoClick && (
            <Touch
              onPress={this.setting}
              style={{
                position: 'absolute',
                width: scaleSize(100),
                height: scaleSize(100),
                bottom: scaleSize(200),
                right: 0,
                backgroundColor: 'rgba(0,0,0,0.1)',
                alignItems: 'center',
                justifyContent: 'center',
                borderRadius: 10,
                zIndex: 999,
              }}>
              <Icons
                name="accessibility"
                style={{fontSize: setSpText(60), color: '#fff'}}
              />
            </Touch>
          )}
          <Touch onPress={this.face} style={styles.btnCome} feedback={false}>
            <View style={styles.click}>
              <Image
                source={
                  faceType === 'wxpay'
                    ? require('../assets/wxpay.png')
                    : require('../assets/Vertical/alipay01.png')
                }
                style={styles.wxpay}
                tintColor="white"
              />
              <Text style={styles.clickText}>点击进入</Text>
              <Image
                source={require('../assets/finger.png')}
                style={styles.finger}
              />
              <Text style={styles.clickText}>刷脸开门</Text>
            </View>
          </Touch>
        </View>
        <View style={styles.footer}>
          {talkCall === 1 ? (
            <View style={styles.footercall}>
              <View style={styles.call}>
                <Image
                  source={
                    faceType === 'wxpay'
                      ? require('../assets/call.gif')
                      : require('../assets/call_blue.gif')
                  }
                  style={styles.callGif}
                />
                <Text style={styles.callText}>正在语音通话中</Text>
              </View>
            </View>
          ) : talkCall === 0 ? (
            <View style={styles.footercall}>
              <View style={styles.call}>
                <Image
                  source={
                    faceType === 'wxpay'
                      ? require('../assets/call.gif')
                      : require('../assets/call_blue.gif')
                  }
                  style={styles.callGif}
                />
                <Text style={styles.callText}>正在接通中请稍候...</Text>
              </View>
            </View>
          ) : (
            <Touch
              onPress={this.onCall}
              style={styles.footercall}
              feedback={false}>
              <View style={styles.call}>
                <Image
                  source={
                    faceType === 'wxpay'
                      ? require('../assets/call.gif')
                      : require('../assets/call_blue.gif')
                  }
                  style={styles.callGif}
                />
                <Text style={styles.callText}>呼叫客服</Text>
              </View>
            </Touch>
          )}
          <View style={styles.goFoot}>
            <View
              style={{
                borderWidth: 10,
                borderColor: '#fff',
                width: scaleSize(220),
                height: scaleSize(220),
                alignItems: 'center',
                justifyContent: 'center',
              }}>
              <QRCode
                value={qrCode || `${qrHost}/#/account`}
                size={scaleSize(190)}
              />
            </View>
            <Text style={styles.goText}>扫码开门</Text>
          </View>
        </View>
      </View>
    );
  }
}

const styles = {
  content: {
    flex: 1,
    alignItems: 'center',
    backgroundColor: '#fff',
  },
  header: {
    flex: 0.2,
    backgroundColor: 'rgb(0,205,102)',
    width: '100%',
    flexDirection: 'column',
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: scaleSize(30),
    marginRight: scaleSize(30),
    marginTop: scaleSize(10),
  },
  headline: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1,
    marginBottom: scaleSize(20),
  },
  headTitle: {
    fontSize: setSpText(70),
    color: '#fff',
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
    marginTop: scaleSize(45),
  },
  imgs: {
    width: scaleSize(60),
    height: scaleSize(60),
    marginRight: scaleSize(20),
    resizeMode: 'contain',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
    marginTop: scaleSize(45),
  },
  img: {
    width: scaleSize(40),
    height: scaleSize(40),
    marginRight: scaleSize(20),
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: setSpText(35),
  },
  phone: {
    width: scaleSize(40),
    height: scaleSize(40),
    marginRight: scaleSize(25),
    resizeMode: 'contain',
  },
  face: {
    flex: 0.6,
    width: '100%',
    flexDirection: 'column',
    alignItems: 'center',
    justifyContent: 'space-around',
    position: 'relative',
  },
  faceRecogn: {
    flex: 0.7,
  },
  faceGif: {
    position: 'relative',
    zIndex: 2,
  },
  btnCome: {
    flex: 0.13,
    backgroundColor: 'rgb(0,205,102)',
    width: '85%',
    borderRadius: scaleSize(20),
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    elevation: 2,
  },
  click: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  clickText: {
    fontSize: setSpText(50),
    color: '#fff',
    marginLeft: setSpText(10),
  },
  wxpay: {
    width: scaleSize(67),
    height: scaleSize(61),
    marginRight: scaleSize(20),
  },
  finger: {
    width: scaleSize(60),
    height: scaleSize(80),
    marginLeft: scaleSize(120),
    marginRight: scaleSize(20),
  },
  footer: {
    flex: 0.2,
    width: '100%',
    flexDirection: 'row',
    backgroundColor: 'rgb(68, 197, 114)',
  },
  call: {
    felx: 1,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    marginTop: scaleSize(20),
  },
  callGif: {
    width: scaleSize(300),
    height: scaleSize(150),
    marginLeft: scaleSize(-100),
    marginTop: scaleSize(80),
  },
  callText: {
    fontSize: setSpText(70),
    color: '#fff',
    marginTop: setSpText(80),
    marginLeft: setSpText(-70),
  },
  onCall: {
    flex: 0.7,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68, 197, 114)',
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  onCallText: {
    fontSize: setSpText(60),
    color: '#fff',
    paddingTop: scaleSize(30),
    paddingLeft: scaleSize(-30),
  },
  footercall: {
    flex: 0.7,
    borderRightColor: '#fff',
    borderRightWidth: 2,
  },
  goFoot: {
    flex: 0.3,
    justifyContent: 'center',
    alignItems: 'center',
  },
  goText: {
    color: '#fff',
    fontSize: setSpText(40),
    paddingTop: scaleSize(10),
  },
};

export default connect(({store}) => ({store}))(FacePage);
