import * as api from '../services/goods';

export default {
  namespace: 'goods',
  state: {
    orderInfo: [],
    bags: [],
    total: 0,
    preTotal: 0,
    status: -1,
  },
  reducers: {
    setOrder(state, {data}) {
      state.orderInfo = data.goods;
      state.total = data.total;
      state.preTotal = data.preTotal;
      state.status = data.status;
      return {...state};
    },
    setBags(state, {data}) {
      state.bags = data;
      return {...state};
    },
  },
  effects: {
    *getBags(action, {put, call}) {
      let {data} = yield call(api.getBags);
      if (data.code === 1) {
        yield put({type: 'setBags', data: data.data});
      }
    },
    *barcodepay(action, {call}) {
      const err = {code: 500, msg: '付款失败，请扫屏幕二维码付款'};
      try {
        let {data} = yield call(api.barcodepay, action);
        if (data.code === 500) {
          return err;
        }
        return data;
      } catch (e) {
        return err;
      }
    },
    *barcodeUser(action, {call}) {
      try {
        let {data} = yield call(api.barcodeUser, action);
        return data;
      } catch (e) {
        return {code: -1};
      }
    },
    *status(action, {call}) {
      try {
        let {data} = yield call(api.status, action);
        return data;
      } catch (e) {
        return {code: -1};
      }
    },
    *getGoods({barcode}, {call}) {
      try {
        return yield call(api.getGoods, barcode);
      } catch (e) {
        return {data: null};
      }
    },
    *postOrder({ids, payType}, {call}) {
      return yield call(api.postOrder, ids, payType);
    },
    *getOrder({id}, {put, call}) {
      let {data} = yield call(api.getOrder, id);
      if (data.code === 1) {
        yield put({type: 'setOrder', data: data.data});
        return data.data.status;
      }
    },
    *canOrder({orderId}, {call}) {
      return yield call(api.canOrder, orderId);
    },
    *faceinfo(action, {call}) {
      return yield call(api.faceinfo, action);
    },
    *alipayinfo(action, {call}) {
      return yield call(api.alipayinfo, action);
    },
    *smilepay(action, {call}) {
      return yield call(api.smilepay, action);
    },
    *wxauthinfo(action, {call}) {
      delete action.type;
      return yield call(api.wxauthinfo, action);
    },
    *payscoreinfo(action, {call}) {
      return yield call(api.payscoreinfo, action);
    },
    *balancePay(action, {call}) {
      return yield call(api.balancePay, action);
    },
  },
};
