import React, {Component} from 'react';
import {StyleSheet} from 'react-native';
import Modal from 'react-native-root-modal';

class ModalView extends Component {
  render() {
    const {visible, children} = this.props;
    return (
      <Modal style={styles.modal} visible={visible}>
        {children}
      </Modal>
    );
  }
}

const styles = StyleSheet.create({
  modal: {
    position: 'absolute',
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'rgba(0, 0, 0, 0.3)',
  },
});

export default ModalView;
