import React from 'react';
import {
  View,
  Text,
  Dimensions,
  FlatList,
  Image,
  Animated,
  Easing,
} from 'react-native';
import Touch from './Touch';
import Icon from 'react-native-vector-icons/Ionicons';
import {setSpText} from '../utils/screen';

const {width, height} = Dimensions.get('screen');

class Car extends React.Component {
  state = {
    filterValue: new Animated.Value(0),
  };

  componentWillReceiveProps(nextProps) {
    this.show(nextProps.carVisible);
  }

  show = carVisible => {
    let {filterValue} = this.state;
    Animated.timing(filterValue, {
      toValue: carVisible ? 1 : 0,
      duration: 800,
      easing: Easing.inOut(Easing.exp),
    }).start();
  };

  // 生成不重复的key
  keyExtractor = (item: any, index: number) => {
    return String(index);
  };

  renderHeader = () => {
    return (
      <View style={{flex: 1, flexDirection: 'column'}}>
        <View
          style={{
            backgroundColor: '#ccc',
            paddingTop: 15,
            paddingBottom: 15,
          }}>
          <View
            style={{
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'center',
            }}>
            <View style={styles.goodsImg}>
              <Text style={styles.ThText}>商品图片</Text>
            </View>
            <View style={styles.goodsName}>
              <Text style={styles.ThText}>商品详情</Text>
            </View>
            <View style={styles.goodsNum}>
              <Text style={styles.ThText}>数量</Text>
            </View>
            <View style={styles.goodsTotal}>
              <Text style={styles.ThText}>金额</Text>
            </View>
          </View>
        </View>
        <View />
      </View>
    );
  };

  renderCell = item => {
    let img = {
      uri: `https://barcod.oss-cn-shenzhen.aliyuncs.com/images/${
        item.barcode
      }.jpg?x-oss-process=style/zmgo_thumb_watermark`,
    };
    return (
      <View style={styles.oddItems}>
        <View style={styles.goodsImg}>
          <Image style={styles.goodsImage} source={img} />
        </View>
        <View style={styles.goodsImgName}>
          <Text style={styles.ItemNumText}>{item.name}</Text>
          <Text style={styles.ItemPrice}>单价:￥{item.prePrice}</Text>
        </View>
        <View style={styles.goodsNum}>
          <Touch style={styles.goodsSub} onPress={() => this.sub(item)}>
            <Image
              style={styles.img}
              source={require('../assets/Order/subtract.png')}
            />
          </Touch>
          <View style={styles.goodsNums}>
            <Text style={styles.ItemText}>{item.num}</Text>
          </View>
          <Touch style={styles.goodsAdd} onPress={() => this.add(item)}>
            <Image
              style={styles.img}
              source={require('../assets/Order/add.png')}
            />
          </Touch>
        </View>
        <View style={styles.goodsTotal}>
          <Text style={styles.ItemText}>
            ￥{(item.prePrice * item.num).toFixed(2)}
          </Text>
        </View>
      </View>
    );
  };

  empty = () => (
    <View style={styles.empty}>
      <View style={styles.emptyImg}>
        <Image style={styles.img} source={require('../assets/Order/car.png')} />
        <Text
          style={{
            textAlign: 'center',
            color: '#ccc',
            fontSize: setSpText(40),
            marginTop: 30,
          }}>
          购物车空空如也~
        </Text>
      </View>
    </View>
  );

  add = v => {
    let {goodsAdd} = this.props;
    goodsAdd(v);
  };

  sub = v => {
    let {goodsSub} = this.props;
    goodsSub(v);
  };

  render() {
    let {goodsMap, goBack, num, total, emptyCar} = this.props;
    let {filterValue} = this.state;
    return (
      <Animated.View
        style={[
          styles.body,
          {
            top: filterValue.interpolate({
              inputRange: [0, 1],
              outputRange: [-height * 0.92, 1],
            }),
          },
        ]}>
        <View>
          <FlatList
            style={styles.carList}
            ListHeaderComponent={this.renderHeader}
            keyExtractor={this.keyExtractor}
            horizontal={false}
            data={goodsMap}
            renderItem={({item}) => this.renderCell(item)}
            ListEmptyComponent={() => this.empty()}
          />
          <View style={styles.footer}>
            <Touch style={styles.back} onPress={() => goBack()}>
              <View>
                <Icon name={'md-arrow-up'} size={30} color={'#fff'} />
                <Text style={{color: '#fff'}}>隐藏</Text>
              </View>
            </Touch>
            <View style={styles.aggregate}>
              <Text>共计 {num} 件</Text>
            </View>
            <View style={styles.aggregate}>
              <Text>总金额:￥{total.toFixed(2)}</Text>
            </View>
            <Touch style={styles.delete} onPress={() => emptyCar()}>
              <View>
                <Icon name={'md-trash'} size={30} color={'#fff'} />
                <Text style={{color: '#fff'}}>清空</Text>
              </View>
            </Touch>
          </View>
        </View>
      </Animated.View>
    );
  }
}

const styles = {
  display: {
    display: 'none',
  },
  body: {
    width,
    height: height * 0.91,
    position: 'absolute',
    zIndex: 9,
    flexDirection: 'row',
  },
  carList: {
    width: width,
    height: height * 0.89,
    // backgroundColor: '#fff',
    backgroundColor: '#f3f4f5',
    paddingBottom: 50,
  },
  goodsImg: {
    width: width * 0.2,
    alignItems: 'center',
    justifyContent: 'center',
  },
  goodsImage: {
    width: 110,
    height: 110,
  },
  goodsName: {
    width: width * 0.35,
    position: 'relative',
  },
  goodsImgName: {
    width: width * 0.35,
    position: 'relative',
  },
  goodsNum: {
    width: width * 0.2,
    flexDirection: 'row',
    justifyContent: 'center',
  },
  goodsSub: {
    width: 30,
    height: 30,
    borderRadius: 30,
    backgroundColor: '#FC4000',
    overflow: 'hidden',
  },
  goodsAdd: {
    width: 30,
    height: 30,
    borderRadius: 30,
    backgroundColor: '#FC4000',
  },
  img: {
    width: '100%',
    height: '100%',
  },
  goodsNums: {
    width: width * 0.15 - 60,
  },
  goodsTotal: {
    width: width * 0.15,
  },
  ThText: {
    textAlign: 'center',
    fontSize: setSpText(40),
  },
  ItemText: {
    textAlign: 'center',
    fontSize: setSpText(30),
  },
  ItemNumText: {
    fontSize: setSpText(30),
    position: 'absolute',
    bottom: 20,
    left: 30,
  },
  ItemPrice: {
    fontSize: setSpText(25),
    color: '#ccc',
    position: 'absolute',
    top: 20,
    left: 30,
  },
  oddItems: {
    height: 120,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: '#fff',
    width: width * 0.95,
    marginLeft: width * 0.025,
    borderRadius: 20,
    marginBottom: 20,
    elevation: 10,
  },
  footer: {
    width: width,
    height: height * 0.06,
    flexDirection: 'row',
    backgroundColor: '#fff',
    borderTopWidth: 1,
    borderTopColor: '#f3f4f5',
    justifyContent: 'center',
  },
  back: {
    flex: 5,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#ccc',
  },
  aggregate: {
    flex: 5,
    justifyContent: 'center',
    alignItems: 'center',
  },
  delete: {
    flex: 5,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'red',
  },
  empty: {
    height: height * 0.5,
    alignItems: 'center',
    justifyContent: 'center',
  },
  emptyImg: {
    width: width * 0.3,
    height: width * 0.3,
  },
};

export default Car;
