import React, {Component} from 'react';
import {Modal, View, Text, Image, TextInput} from 'react-native';
import Icon from 'react-native-vector-icons/Ionicons';
import MIcon from 'react-native-vector-icons/MaterialCommunityIcons';
import ModalStyles from './Modal/styles';
import {colors, font} from '../utils/common';
import Touch from './Touch';
import phone from '../assets/Vertical/phone.png';
import {setSpText, scaleSize} from '../utils/screen';

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
    // width: 380,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

class PhoneModal extends Component {
  state = {
    value: '',
  };

  componentWillMount = async () => {
    this.setState({
      value: '',
    });
  };

  getKeyboard = () => {
    const rows = [];
    let items = [];
    for (let i = 1; i <= 9; i++) {
      let unit;
      unit = <Text style={styles.keyUnit}>{i}</Text>;
      const item = (
        <Touch style={styles.keyTouch} key={i} onPress={() => this.pressKey(i)}>
          {unit}
        </Touch>
      );
      items.push(item);
      if (i % 3 === 0) {
        rows.push(
          <View style={styles.keyRow} key={i}>
            {items}
          </View>,
        );
        items = [];
      }
    }
    return <View style={styles.NumberTop}>{rows}</View>;
  };

  pressKey = async index => {
    let {value} = this.state;
    const {onSubmit} = this.props;
    if (index < 10) {
      value += index;
    } else if (index === 11) {
      value = value.substr(0, value.length - 1);
    } else if (index === 12) {
      await this.setState({value: ''});
      await onSubmit(value);
      return;
    }
    this.setState({value});
  };

  render() {
    const {onCall, faceType, ...props} = this.props;
    const {value} = this.state;
    if (faceType === 'alipay') {
      styles.header = {...styles.header, backgroundColor: '#1b7dc7'};
      styles.keyTouchOnSure = {
        ...styles.keyTouchOnSure,
        backgroundColor: '#1b7dc7',
      };
      styles.keyTouchSure = {
        ...styles.keyTouchSure,
        backgroundColor: '#87CEFA',
      };
    }
    return (
      <Modal styles={mStyles} {...props}>
        <View style={styles.modalBackgroundStyle}>
          <View style={styles.modal}>
            <View style={styles.header}>
              <View style={styles.title}>
                <View style={styles.left}>
                  <Image
                    source={require('../assets/logo.png')}
                    style={styles.img}
                  />
                  <Text style={styles.text}>安全验证手机号</Text>
                </View>
                <Touch onPress={() => onCall()}>
                  <View style={styles.right}>
                    {/*<Icon name="md-close" color={'#FFFFFF'} size={50} />*/}
                    <Text style={styles.text}>呼叫客服</Text>
                    <Image style={styles.phone} source={phone} />
                  </View>
                </Touch>
              </View>
              <View style={styles.image}>
                <Image
                  source={require('../assets/logo2.png')}
                  style={styles.logo}
                />
              </View>
            </View>
            <View style={styles.container}>
              <Text
                style={{
                  color: 'red',
                  fontSize: setSpText(70),
                  marginBottom: scaleSize(10),
                }}>
                请输入接收验证码的手机号
              </Text>
              <View
                style={{
                  flexDirection: 'row',
                  justifyContent: 'center',
                  alignItems: 'center',
                }}>
                <TextInput
                  style={{
                    fontSize: setSpText(70),
                    width: '80%',
                    textAlign: 'center',
                    padding: scaleSize(20),
                    color: '#000',
                  }}
                  placeholder="安全输入不留痕迹"
                  placeholderTextColor="lightgray"
                  editable={false}
                  value={value}
                />
                <Touch
                  onPress={() => this.setState({value: ''})}
                  feddback={false}>
                  <Icon
                    name="md-close"
                    color={'#DCDCDC'}
                    size={scaleSize(120)}
                  />
                </Touch>
              </View>
            </View>
            <View style={styles.footer}>
              <View style={styles.footerLeft}>
                {this.getKeyboard()}
                <View style={styles.keyRowBottom}>
                  <Touch
                    style={styles.keyBottomTouch}
                    onPress={() => this.pressKey(0)}>
                    <Text style={styles.keyUnit}>0</Text>
                  </Touch>
                </View>
              </View>
              <View style={styles.footerRight}>
                <View style={styles.keyRowClose}>
                  <Touch
                    style={styles.keyTouchClose}
                    onPress={() => this.pressKey(11)}>
                    <MIcon
                      style={styles.keyUnit}
                      name="backspace-outline"
                      size={scaleSize(10)}
                    />
                  </Touch>
                </View>
                <View style={styles.keyRowSure}>
                  {/* <Touch style={styles.keyTouchSure} onPress={() => this.pressKey(12)}>*/}
                  {/*  <Text style={styles.keyUnitClose}>确定</Text>*/}
                  {/* </Touch>*/}
                  {value.length < 1 ? (
                    <View style={styles.keyTouchSure}>
                      <Text style={styles.keyUnitClose}>确定</Text>
                    </View>
                  ) : (
                    <Touch
                      style={styles.keyTouchOnSure}
                      onPress={() => this.pressKey(12)}>
                      <Text style={styles.keyUnitClose}>确定</Text>
                    </Touch>
                  )}
                </View>
              </View>
            </View>
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  modalBackgroundStyle: {
    flex: 1,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
  },
  modal: {
    height: '86%',
    width: '90%',
    marginLeft: '5%',
    marginTop: '10%',
    borderRadius: 20,
    backgroundColor: '#cccccc',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  header: {
    flex: 0.4,
    backgroundColor: '#00CD66',
    width: '100%',
    flexDirection: 'column',
    borderTopRightRadius: 10,
    borderTopLeftRadius: 10,
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: scaleSize(20),
    marginRight: scaleSize(20),
    marginTop: scaleSize(5),
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
    marginTop: scaleSize(20),
  },
  img: {
    width: scaleSize(120),
    height: scaleSize(120),
    marginRight: scaleSize(10),
    resizeMode: 'contain',
  },
  phone: {
    width: scaleSize(60),
    height: scaleSize(60),
    marginRight: scaleSize(10),
    resizeMode: 'contain',
  },
  image: {
    flex: 1,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  logo: {
    width: scaleSize(320),
    height: scaleSize(320),
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: setSpText(65),
  },
  container: {
    flex: 0.2,
    backgroundColor: '#FFFFFF',
    width: '100%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  footer: {
    flex: 0.4,
    width: '100%',
    flexDirection: 'row',
    backgroundColor: '#F5F5F5',
    borderBottomLeftRadius: 10,
    borderBottomRightRadius: 10,
  },
  footerLeft: {
    width: '75%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  NumberTop: {
    flex: 0.8,
  },
  keyRow: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: scaleSize(25),
    marginLeft: scaleSize(50),
    marginRight: scaleSize(25),
    flex: 0.33,
  },
  keyRowBottom: {
    width: '100%',
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: scaleSize(25),
    marginLeft: scaleSize(50),
    marginRight: scaleSize(25),
    marginBottom: scaleSize(25),
    flex: 0.2,
  },
  keyBottomTouch: {
    width: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#FFFFFF',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyTouch: {
    width: '33%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#FFFFFF',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyUnit: {
    fontSize: setSpText(100),
    color: colors.text,
  },
  footerRight: {
    width: '25%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  keyRowClose: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: scaleSize(25),
    marginLeft: scaleSize(45),
    marginRight: scaleSize(15),
    flex: 0.22,
  },
  keyTouchClose: {
    width: '90%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#FFFFFF',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyRowSure: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: scaleSize(25),
    marginLeft: scaleSize(45),
    marginRight: scaleSize(15),
    marginBottom: scaleSize(25),
    flex: 0.78,
  },
  keyTouchSure: {
    width: '90%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#76EEC6',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyTouchOnSure: {
    width: '90%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#00CD66',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyUnitClose: {
    fontSize: setSpText(85),
    color: '#FFFFFF',
    textAlign: 'center',
  },
};

export default PhoneModal;
