import React, {Component} from 'react';
import {Modal, View, Text, Image} from 'react-native';
// import Icon from 'react-native-vector-icons/Ionicons';
import MIcon from 'react-native-vector-icons/MaterialCommunityIcons';
import ModalStyles from './Modal/styles';
import {colors, font} from '../utils/common';
import Touch from './Touch';
import phone from '../assets/Vertical/phone.png';

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
    // width: 380,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

class VerifyCodeModal extends Component {
  state = {
    value: '',
  };

  getKeyboard = () => {
    const rows = [];
    let items = [];
    for (let i = 1; i <= 9; i++) {
      let unit;
      unit = <Text style={styles.keyUnit}>{i}</Text>;
      const item = (
        <Touch style={styles.keyTouch} key={i} onPress={() => this.pressKey(i)}>
          {unit}
        </Touch>
      );
      items.push(item);
      if (i % 3 === 0) {
        rows.push(
          <View style={styles.keyRow} key={i}>
            {items}
          </View>,
        );
        items = [];
      }
    }
    return <View style={styles.NumberTop}>{rows}</View>;
  };

  pressKey = index => {
    let {value} = this.state;
    const {onSubmit} = this.props;
    if (index < 10 && value.length < 4) {
      value += index;
      if (value.length === 4) {
        onSubmit(value);
      }
    } else if (index === 11) {
      value = value.substr(0, value.length - 1);
    } else if (index === 12) {
      // this.setState({value: ''});
      onSubmit(value);
      return;
    }
    this.setState({value});
  };

  render() {
    const {onCall, ...props} = this.props;
    const {value} = this.state;
    return (
      <Modal styles={mStyles} {...props}>
        <View style={styles.modalBackgroundStyle}>
          <View style={styles.modal}>
            <View style={styles.header}>
              <View style={styles.title}>
                <View style={styles.left}>
                  <Image
                    source={require('../assets/logo.png')}
                    style={styles.img}
                  />
                  <Text style={styles.text}>安全验证手机号</Text>
                </View>
                <Touch onPress={() => onCall()}>
                  <View style={styles.right}>
                    {/*<Icon name="md-close" color={'#FFFFFF'} size={50} />*/}
                    <Text style={styles.text}>呼叫客服</Text>
                    <Image style={styles.phone} source={phone} />
                  </View>
                </Touch>
              </View>
              <View style={styles.image}>
                <Image
                  source={require('../assets/logo2.png')}
                  style={styles.logo}
                />
              </View>
            </View>
            <View style={styles.container}>
              <Text style={styles.tips}>请输入验证码</Text>
              <View style={styles.codeView}>
                <Text style={styles.code}>
                  {value && value.length >= 1 ? value.substr(0, 1) : ''}
                </Text>
                <Text style={styles.code}>
                  {value && value.length >= 2 ? value.substr(1, 1) : ''}
                </Text>
                <Text style={styles.code}>
                  {value && value.length >= 3 ? value.substr(2, 1) : ''}
                </Text>
                <Text style={styles.code}>
                  {value && value.length >= 4 ? value.substr(3, 1) : ''}
                </Text>
              </View>
            </View>
            <View style={styles.footer}>
              <View style={styles.footerLeft}>
                {this.getKeyboard()}
                <View style={styles.keyRowBottom}>
                  <Touch
                    style={styles.keyBottomTouch}
                    onPress={() => this.pressKey(0)}>
                    <Text style={styles.keyUnit}>0</Text>
                  </Touch>
                </View>
              </View>
              <View style={styles.footerRight}>
                <View style={styles.keyRowClose}>
                  <Touch
                    style={styles.keyTouchClose}
                    onPress={() => this.pressKey(11)}>
                    <MIcon
                      style={styles.keyUnit}
                      name="backspace-outline"
                      size={60}
                    />
                  </Touch>
                </View>
                <View style={styles.keyRowSure}>
                  {value.length < 4 ? (
                    <View style={styles.keyTouchSure}>
                      <Text style={styles.keyUnitClose}>确定</Text>
                    </View>
                  ) : (
                    <Touch
                      style={styles.keyTouchOnSure}
                      onPress={() => this.pressKey(12)}>
                      <Text style={styles.keyUnitClose}>确定</Text>
                    </Touch>
                  )}
                </View>
              </View>
            </View>
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  modalBackgroundStyle: {
    flex: 1,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
  },
  modal: {
    height: '90%',
    width: '90%',
    marginLeft: '5%',
    marginTop: '6%',
    borderRadius: 20,
    backgroundColor: '#cccccc',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  header: {
    flex: 0.4,
    backgroundColor: '#00CD66',
    width: '100%',
    flexDirection: 'column',
    borderTopRightRadius: 10,
    borderTopLeftRadius: 10,
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: 30,
    marginRight: 30,
    marginTop: 10,
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
    marginTop: 15,
  },
  img: {
    width: 80,
    height: 80,
    marginRight: 10,
    resizeMode: 'contain',
  },
  phone: {
    width: 40,
    height: 40,
    marginRight: 10,
    resizeMode: 'contain',
  },
  image: {
    flex: 1,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  logo: {
    width: 150,
    height: 150,
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: 30,
  },
  container: {
    flex: 0.3,
    backgroundColor: '#FFFFFF',
    width: '100%',
    flexDirection: 'column',
    justifyContent: 'center',
  },
  tips: {
    color: 'red',
    fontSize: 45,
    marginBottom: 10,
    textAlign: 'center',
  },
  codeView: {
    flexDirection: 'row',
    justifyContent: 'space-around',
    alignItems: 'center',
    flex: 0.5,
    marginTop: 30,
  },
  code: {
    height: '100%',
    width: '15%',
    borderWidth: 4,
    borderColor: '#DCDCDC',
    textAlign: 'center',
    fontSize: 50,
    textAlignVertical: 'center',
  },
  footer: {
    flex: 0.4,
    width: '100%',
    flexDirection: 'row',
    backgroundColor: '#F5F5F5',
    borderBottomLeftRadius: 10,
    borderBottomRightRadius: 10,
  },
  footerLeft: {
    width: '75%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  NumberTop: {
    flex: 0.8,
  },
  keyRow: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: 10,
    marginLeft: 20,
    marginRight: 10,
    flex: 0.33,
  },
  keyRowBottom: {
    width: '100%',
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: 10,
    marginLeft: 20,
    marginRight: 10,
    marginBottom: 10,
    flex: 0.2,
  },
  keyBottomTouch: {
    width: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#FFFFFF',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyTouch: {
    width: '33%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#FFFFFF',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyUnit: {
    fontSize: 50,
    color: colors.text,
  },
  footerRight: {
    width: '25%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  keyRowClose: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginLeft: 10,
    marginTop: 10,
    marginRight: 5,
    flex: 0.25,
  },
  keyTouchClose: {
    width: '90%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#FFFFFF',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyRowSure: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginLeft: 10,
    marginTop: 10,
    marginBottom: 10,
    marginRight: 5,
    flex: 0.75,
  },
  keyTouchSure: {
    width: '90%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#76EEC6',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyTouchOnSure: {
    width: '90%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#00CD66',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyUnitClose: {
    fontSize: 50,
    color: '#FFFFFF',
  },
};

export default VerifyCodeModal;
