import React from 'react';
import {
  View,
  Dimensions,
  Image,
  Text,
  TextInput,
  ScrollView,
} from 'react-native';
import {setSpText} from '../utils/screen';
import {connect} from 'react-redux';
import Touch from './Touch';
// import GoodsList from './GoodsList';

const {width, height} = Dimensions.get('screen');

@connect(({searchGoods}) => ({searchGoods}))
class SearchGoods extends React.Component {
  state = {
    goodsArr: [],
    // value:'',
  };
  search = async text => {
    let {data} = await this.props.dispatch({
      type: 'searchGoods/getStoreGoods',
      keyword: text,
      page: 0,
      size: 10,
    });
    this.setState({
      goodsArr: data.data,
    });
  };
  render() {
    let {
      searchVisible,
      cancelSearch,
      goodsNumber,
      goodsAdd,
      goodsSub,
    } = this.props;
    let {goodsArr} = this.state;
    return (
      <View style={searchVisible ? styles.body : styles.display}>
        <View style={styles.search}>
          <View>
            <View style={styles.searchInput}>
              <View style={styles.searchIcon}>
                <Image
                  style={styles.img}
                  source={require('../assets/Order/search.png')}
                />
              </View>
              <View style={styles.searchText}>
                <TextInput
                  style={styles.input}
                  onChange={({nativeEvent: {text}}) => this.search(text)}
                />
              </View>
              <Text
                style={styles.searchBtn}
                onPress={() => {
                  cancelSearch(), this.setState({goodsArr: []});
                }}>
                取消
              </Text>
            </View>
          </View>
        </View>
        <ScrollView style={styles.searchList}>
          <View style={styles.goodsBox}>
            {goodsArr.length > 0 &&
              goodsArr.map((v, key) => {
                let img = {
                  uri: `https://barcod.oss-cn-shenzhen.aliyuncs.com/images/${
                    v.barcode
                  }.jpg?x-oss-process=style/zmgo_thumb_watermark`,
                };
                return (
                  <View style={styles.goodsItem} key={key}>
                    <View style={styles.goodsImg}>
                      <Image style={styles.img} source={img} />
                    </View>
                    <Text style={styles.goodsName}>{v.name}</Text>
                    <Text style={styles.goodsPrice}>￥{v.prePrice}</Text>
                    <View style={styles.goodsNum}>
                      <Touch
                        style={
                          goodsNumber[v.barcode] &&
                          goodsNumber[v.barcode].num > 0
                            ? styles.goodsSub
                            : styles.display
                        }
                        onPress={() => {
                          goodsSub(v);
                        }}>
                        <Image
                          style={styles.img}
                          source={require('../assets/Order/subtract.png')}
                        />
                      </Touch>
                      <Text
                        style={
                          goodsNumber[v.barcode] &&
                          goodsNumber[v.barcode].num > 0
                            ? styles.goodsNums
                            : styles.display
                        }>
                        {goodsNumber[v.barcode]
                          ? goodsNumber[v.barcode].num
                          : ''}
                      </Text>
                      <Touch
                        style={styles.goodsAdd}
                        onPress={() => {
                          goodsAdd(v);
                        }}>
                        <Image
                          style={styles.img}
                          source={require('../assets/Order/add.png')}
                        />
                      </Touch>
                    </View>
                  </View>
                );
              })}
          </View>
        </ScrollView>
      </View>
    );
  }
}

const styles = {
  body: {
    width,
    height,
    position: 'absolute',
    zIndex: 8,
    backgroundColor: '#fff',
  },
  display: {
    display: 'none',
  },
  search: {
    width,
    height: height * 0.07,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  searchInput: {
    width: width * 0.9,
    height: height * 0.07 * 0.85,
    borderWidth: 1,
    borderColor: '#ccc',
    borderRadius: height * 0.07 * 0.85,
    flexDirection: 'row',
    alignItems: 'center',
  },
  input: {
    width: '100%',
    height: '100%',
    fontSize: setSpText(50),
  },
  searchIcon: {
    width: width * 0.08,
    height: width * 0.08,
    marginLeft: 20,
  },
  searchText: {
    width: width * 0.63,
    height: height * 0.07 * 0.85,
  },
  searchBtn: {
    width: width * 0.15,
    height: height * 0.07 * 0.7,
    borderRadius: height * 0.07 * 0.7,
    fontSize: setSpText(50),
    color: '#fff',
    backgroundColor: '#fc4000',
    textAlign: 'center',
    lineHeight: height * 0.07 * 0.7,
  },
  img: {
    width: '100%',
    height: '100%',
  },
  searchList: {
    width: width,
    height: height * 0.93,
    paddingBottom: height * 0.07,
    borderTopColor: '#ccc',
  },
  goodsBox: {
    width: width,
    height: height * 0.93,
    flexDirection: 'row',
    flexWrap: 'wrap',
    backgroundColor: '#f3f4f5',
  },
  goodsItem: {
    width: width * 0.3,
    height: height * 0.8 * 0.3,
    marginTop: 20,
    marginLeft: width * 0.025,
    alignItems: 'center',
    backgroundColor: '#fff',
    borderRadius: 20,
    elevation: 10,
  },
  goodsImg: {
    width: width * 0.85 * 0.3333 * 0.95,
    height: width * 0.85 * 0.3333 * 0.8,
    marginTop: 10,
  },
  goodsName: {
    width: width * 0.85 * 0.3333 * 0.95,
    height: 40,
    lineHeight: 50,
    fontSize: setSpText(30),
  },
  goodsPrice: {
    width: width * 0.85 * 0.3333 * 0.9,
    height: 25,
    paddingRight: 20,
    marginTop: 5,
    marginBottom: 5,
    color: '#e21918',
    fontSize: setSpText(20),
  },
  goodsNum: {
    width: width * 0.85 * 0.3333 * 0.9,
    height: 40,
    position: 'relative',
  },
  goodsSub: {
    width: 40,
    height: 40,
    borderRadius: 40,
    backgroundColor: '#fc4000',
  },
  goodsNums: {
    width: width * 0.85 * 0.3333 * 0.9 - 100,
    height: 40,
    textAlign: 'center',
    fontSize: 40,
    position: 'absolute',
    left: 50,
  },
  goodsAdd: {
    width: 40,
    height: 40,
    borderRadius: 40,
    backgroundColor: '#fc4000',
    position: 'absolute',
    right: 0,
  },
};

export default SearchGoods;
