import React from 'react';
import {View, TextInput, Text} from 'react-native';
import Icon from 'react-native-vector-icons/Ionicons';
import {colors, font} from '../utils/common';
import Touch from './Touch';
import Modal from './Modal';
import ModalStyles from './Modal/styles';

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
    width: 777,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

const keyboard = [
  {up: '1', down: '1'},
  {up: '2', down: '2'},
  {up: '3', down: '3'},
  {up: '4', down: '4'},
  {up: '5', down: '5'},
  {up: '6', down: '6'},
  {up: '7', down: '7'},
  {up: '8', down: '8'},
  {up: '9', down: '9'},
  {up: '0', down: '0'},
  {up: 'Q', down: 'q'},
  {up: 'W', down: 'w'},
  {up: 'E', down: 'e'},
  {up: 'R', down: 'r'},
  {up: 'T', down: 't'},
  {up: 'Y', down: 'y'},
  {up: 'U', down: 'u'},
  {up: 'I', down: 'i'},
  {up: 'O', down: 'o'},
  {up: 'P', down: 'p'},
  {up: 'A', down: 'a'},
  {up: 'S', down: 's'},
  {up: 'D', down: 'd'},
  {up: 'F', down: 'f'},
  {up: 'G', down: 'g'},
  {up: 'H', down: 'h'},
  {up: 'J', down: 'j'},
  {up: 'K', down: 'k'},
  {up: 'L', down: 'l'},
  {up: 'tran', down: 'tran'},
  {up: 'Z', down: 'z'},
  {up: 'X', down: 'x'},
  {up: 'C', down: 'c'},
  {up: 'V', down: 'v'},
  {up: 'B', down: 'b'},
  {up: 'N', down: 'n'},
  {up: 'M', down: 'm'},
  {up: 'del', down: 'del'},
];

export default class KeyboardModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      caseUp: false,
      value: '',
    };
  }

  getKeyboard = () => {
    let {caseUp} = this.state;
    let keyboard1 = keyboard.slice(0, 10);
    let keyboard2 = keyboard.slice(10, 20);
    let keyboard3 = keyboard.slice(20, 29);
    let keyboard4 = keyboard.slice(29, 38);
    return (
      <View style={{width: 667, marginLeft: 40}}>
        <View style={styles.keyRow}>
          {keyboard1.map((item, index) => (
            <Touch
              style={styles.keyTouch}
              key={index}
              onPress={() => this.pressKey(index)}>
              <Text style={styles.keyUnit}>{item.up}</Text>
            </Touch>
          ))}
        </View>
        <View style={styles.keyRow}>
          {keyboard2.map((item, index) => (
            <Touch
              style={styles.keyTouch}
              key={index}
              onPress={() => this.pressKey(index + 10)}>
              <Text style={styles.keyUnit}>{caseUp ? item.up : item.down}</Text>
            </Touch>
          ))}
        </View>
        <View style={styles.keyRow}>
          {keyboard3.map((item, index) => (
            <Touch
              style={styles.keyTouch}
              key={index}
              onPress={() => this.pressKey(index + 20)}>
              <Text style={styles.keyUnit}>{caseUp ? item.up : item.down}</Text>
            </Touch>
          ))}
        </View>
        <View style={styles.keyRow}>
          {keyboard4.map((item, index) => {
            if (index === 0) {
              return (
                <Touch
                  style={[styles.keyTouch, {width: 60, marginRight: 15}]}
                  key={index}
                  onPress={() => this.pressKey(index + 29)}>
                  <Icon
                    name={caseUp ? 'md-arrow-round-down' : 'md-arrow-round-up'}
                    size={30}
                  />
                </Touch>
              );
            } else if (index === 8) {
              return (
                <Touch
                  style={[styles.keyTouch, {width: 60, marginLeft: 15}]}
                  key={index}
                  onPress={() => this.pressKey(index + 29)}>
                  <Icon name="md-backspace" size={30} />
                </Touch>
              );
            }
            return (
              <Touch
                style={styles.keyTouch}
                key={index}
                onPress={() => this.pressKey(index + 29)}>
                <Text style={styles.keyUnit}>
                  {caseUp ? item.up : item.down}
                </Text>
              </Touch>
            );
          })}
        </View>
      </View>
    );
  };

  pressKey = index => {
    let {value} = this.state;
    if (index === 29) {
      this.setState({
        caseUp: !this.state.caseUp,
      });
    } else if (index === 37) {
      value = value.substring(0, value.length - 1);
      this.setState({value});
    } else {
      value += this.state.caseUp ? keyboard[index].up : keyboard[index].down;
      this.setState({value});
    }
  };

  render() {
    const {title, visible, onSubmit, onClose} = this.props;
    const {value} = this.state;
    return (
      <Modal
        styles={mStyles}
        visible={visible}
        transparent
        maskClosable
        onClose={onClose}
        title={title}>
        <View
          style={{
            borderTopColor: '#cccccc',
            borderTopWidth: 1,
            paddingVertical: 20,
          }}>
          <View
            style={{
              width: 777,
              height: 60,
              justifyContent: 'center',
              position: 'relative',
            }}>
            <TextInput
              autoFocus
              value={value}
              style={{width: 667, fontSize: font.textActive, marginLeft: 40}}
              onSubmitEditing={() => onSubmit(value)}
            />
            <Touch
              onPress={() => this.setState({value: ''})}
              style={{position: 'absolute', right: 82}}>
              <Icon name="ios-close" size={40} color="#D1D1D1" />
            </Touch>
          </View>
          {this.getKeyboard()}
          <View
            style={{
              flexDirection: 'row',
              justifyContent: 'center',
              marginTop: 30,
            }}>
            <Touch
              onPress={onClose}
              style={{
                width: 100,
                height: 50,
                justifyContent: 'center',
                alignItems: 'center',
                borderWidth: 1,
                borderColor: '#cccccc',
                marginRight: 30,
                borderRadius: 5,
              }}>
              <Text style={{color: '#2B2B2B', fontSize: font.textS}}>取消</Text>
            </Touch>
            <Touch
              onPress={() => onSubmit(value)}
              style={{
                width: 100,
                height: 50,
                backgroundColor: '#E3430F',
                justifyContent: 'center',
                alignItems: 'center',
                borderWidth: 1,
                borderColor: '#E3430F',
                borderRadius: 5,
              }}>
              <Text style={{color: '#ffffff', fontSize: font.textS}}>确定</Text>
            </Touch>
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  keyRow: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: 15,
  },
  keyTouch: {
    width: 60,
    height: 60,
    justifyContent: 'center',
    alignItems: 'center',
    borderWidth: 1,
    borderColor: '#cccccc',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyUnit: {
    fontSize: font.textActive,
    color: colors.text,
  },
};
