import React, {Component} from 'react';
import {Dimensions, Image, Text, View} from 'react-native';
import {appName} from '../utils/config';
import {setSpText, scaleSize} from '../utils/screen';
const {width, height} = Dimensions.get('window');

class HomeLayout extends Component {
  render() {
    return (
      <View style={styles.container}>
        <View style={styles.title}>
          <Image
            style={styles.titleImg}
            source={require('../assets/logo2.png')}
            resizeMode="contain"
          />
          <Image
            style={{marginLeft: scaleSize(40)}}
            source={require('../assets/Vertical/24h.png')}
          />
          <Text style={styles.titleText}>{appName}</Text>
          <View
            style={{
              flex: 1,
              flexDirection: 'row',
              justifyContent: 'flex-end',
              alignItems: 'flex-end',
              paddingRight: 25,
            }}>
            <Text style={{fontSize: 12, color: '#ccc'}}>
              {width.toFixed(0)} - {height.toFixed(0)}
            </Text>
          </View>
        </View>
        {this.props.children}
      </View>
    );
  }
}

const LandscapeStyles = {
  title: {
    top: 0,
    paddingLeft: scaleSize(50),
    flexDirection: 'row',
    height: scaleSize(width > height ? height * 0.12 : height * 0.2), // 修改了这里
    width: '100%',
    position: 'absolute',
    backgroundColor: 'white',
    alignItems: 'center',
    elevation: 10,
    background: '#f5f5f5',
  },
  titleImg: {
    width: scaleSize(75), // 修改了这里
    height: scaleSize(75), // 修改了这里
  },
  titleText: {
    color: '#333',
    fontSize: setSpText(60),
    marginLeft: 30,
  },
  container: {
    flex: 1,
    backgroundColor: '#ffffff',
    justifyContent: 'center',
    alignItems: 'center',
  },
};

const portraitStyles = {
  title: {
    top: 0,
    paddingLeft: scaleSize(50),
    flexDirection: 'row',
    height: scaleSize(220),
    width: '100%',
    position: 'absolute',
    backgroundColor: 'white',
    alignItems: 'center',
    elevation: 10,
    background: '#f5f5f5',
  },
  titleImg: {
    width: scaleSize(150),
    height: scaleSize(150),
  },
  titleText: {
    color: '#333',
    fontSize: setSpText(60),
    marginLeft: 30,
  },
  container: {
    flex: 1,
    backgroundColor: '#ffffff',
    justifyContent: 'center',
    alignItems: 'center',
  },
};

const isLandscape = width > height;

const styles = isLandscape ? LandscapeStyles : portraitStyles;

export default HomeLayout;
