import React, {Component} from 'react';
import {connect} from 'react-redux';
import AsyncStorage from '@react-native-community/async-storage';
import {View, Text, Image, Modal, TextInput, FlatList} from 'react-native';
import {debounce} from 'throttle-debounce';
import Touch from '../components/Touch';
import Speech from '../utils/Speech';
import {scaleSize, setSpText} from '../utils/screen';
import WxFacepay from '../utils/WxFacepay';
import UdpBroadcast from '../utils/UdpBroadcast';

class GuardPage extends Component {
  async componentWillMount() {
    // AsyncStorage.removeItem('password'); // 清除密码

    // AsyncStorage.removeItem('datas'); // 清除全部人员！！！！！
    const password = await AsyncStorage.getItem('password');
    const order = await AsyncStorage.getItem('order');
    const datas = await AsyncStorage.getItem('datas');
    if (datas) {
      await this.setState({datas: JSON.parse(datas)});
    }
    await this.setState({password, order});
  }

  state = {
    tipText: '触摸屏幕，人脸识别，打开门禁',
    touch: 0,
    visible: false,
    adminVisible: false,
    passwordVisible: false,
    orderVisible: false,
    tableVisible: false,
    delVisible: false,
    inputText: '',
    password: '',
    order: '',
    newPassword: '',
    newPasswords: '',
    datas: [],
    id: '',
    name: '',
  };

  // 微信人脸身份识别
  wechatFace = async () => {
    const tipText = '正在识别您的身份';
    Speech.speak(tipText);
    let {datas, order} = this.state;
    let auth = (await this.authinfo()) || {};
    // Speech.speak('正在识别您的身份');
    if (
      auth.return_code === 'SUCCESS' ||
      (auth.code === 1 && auth.data.bizCode === '0000')
    ) {
      if (auth.data) {
        auth = auth.data;
      }
      const params = {
        appid: auth.appid || auth.subAppId,
        mch_id: auth.mch_id || auth.subMchId,
        store_id: this.storeKey,
        authinfo: auth.authinfo || auth.authInfo,
        face_authtype: 'FACEID-ONCE',
        ask_unionid: 1,
      };
      let res = (await WxFacepay.faceinfo(params)) || {};
      if (!res.openid) {
        // 返回错误自动重新识别
        // 没识别到人脸
        return;
      }
      let flag = true;

      datas.map(v => {
        if (v.id === res.sub_openid && v.status) {
          UdpBroadcast.send({data: order});
          Speech.speak('门已经打开');
          flag = false;
        }
      });
      if (flag) {
        Speech.speak('您没有权限，请联系管理员');
      }
    }
  };

  goAdmin = async () => {
    this.setState({
      visible: true,
    });
  };

  debounceFuncs = debounce(500, false, num => {
    this.wechatFace();
  });

  debounceFunc = debounce(300, false, num => {
    this.setState({
      touch: 0,
    });
    if (num === 1) {
      this.wechatFace();
    } else if (num === 5) {
      this.goAdmin();
    }
  });

  touch = async () => {
    let {touch} = this.state;
    let num = touch;
    num++;
    await this.setState({
      touch: num,
    });
    this.debounceFunc(num);
  };

  closeHint = () => {
    this.setState({
      visible: false,
    });
  };

  submit = () => {
    let {inputText, password} = this.state;
    if (inputText.length < 6) return Speech.speak('请输入六位数或以上的密码');
    if (password) {
      if (inputText === password) {
        this.setState({
          visible: false,
          adminVisible: true,
        });
      } else {
        Speech.speak('密码错误');
        this.setState({
          visible: false,
        });
      }
    } else {
      this.setState({
        password: inputText,
        visible: false,
        adminVisible: true,
      });
      AsyncStorage.setItem('password', inputText);
      Speech.speak('密码设置成功');
    }
  };

  verify = () => {
    let {newPassword, newPasswords} = this.state;
    if (newPassword.length < 6) return Speech.speak('请输入六位数或以上');
    if (newPassword === newPasswords) {
      this.setState({
        passwordVisible: false,
        password: newPassword,
      });
      AsyncStorage.setItem('password', newPassword);
      Speech.speak('密码设置成功');
    } else {
      Speech.speak('密码不一致');
    }
  };

  order = () => {
    let {order} = this.state;
    this.setState({
      orderVisible: false,
    });
    AsyncStorage.setItem('order', order);
    Speech.speak('指令设置成功');
  };

  authinfo = async () => {
    const rawdata = await WxFacepay.rawdata();
    const {data} = await this.props.dispatch({
      type: 'goods/faceinfo',
      rawdata,
    });
    return data;
  };

  table = async () => {
    let {datas} = this.state;
    let auth = (await this.authinfo()) || {};
    // Speech.speak('正在识别您的身份');
    if (
      auth.return_code === 'SUCCESS' ||
      (auth.code === 1 && auth.data.bizCode === '0000')
    ) {
      if (auth.data) {
        auth = auth.data;
      }
      const params = {
        appid: auth.appid || auth.subAppId,
        mch_id: auth.mch_id || auth.subMchId,
        store_id: this.storeKey,
        authinfo: auth.authinfo || auth.authInfo,
        face_authtype: 'FACEID-ONCE',
        ask_unionid: 1,
      };
      let res = (await WxFacepay.faceinfo(params)) || {};
      if (!res.openid) {
        // 返回错误自动重新识别
        // 没识别到人脸
        return;
      }
      let flag = true;
      let key = 0;
      datas.map(v => {
        if (v.id === res.sub_openid) {
          flag = false;
        }
        key++;
      });
      if (flag) {
        let obj = {
          name: res.nickname,
          id: res.sub_openid,
          status: true,
          key,
        };
        datas.push(obj);
        AsyncStorage.setItem('datas', JSON.stringify(datas));
        this.setState({
          datas,
        });
        Speech.speak('添加成功');
      } else {
        Speech.speak('该角色已添加');
      }
    }
  };

  status = id => {
    let {datas} = this.state;
    let arr = [];
    datas.map(v => {
      let obj = v;
      if (v.id === id) {
        obj.status = !obj.status;
      }
      arr.push(obj);
    });
    AsyncStorage.setItem('datas', JSON.stringify(arr));
    this.setState({
      datas: arr,
    });
  };

  delete = (id, name) => {
    this.setState({id, name, delVisible: true});
  };

  reamove = () => {
    let {id, datas} = this.state;
    this.setState({id, delVisible: false});
    let arr = [];
    let key = 0;
    datas.map(v => {
      let obj = v;
      if (v.id !== id) {
        obj.key = key;
        key++;
        arr.push(obj);
      }
    });
    Speech.speak('删除成功');
    AsyncStorage.setItem('datas', JSON.stringify(arr));
    this.setState({datas: arr});
  };

  render() {
    const {
      tipText,
      visible,
      adminVisible,
      passwordVisible,
      tableVisible,
      orderVisible,
      delVisible,
      order,
      datas,
      name,
    } = this.state;

    const Item = ({item}) => {
      return (
        <View
          key={item.key}
          style={item.key % 2 === 0 ? styles.itemOne : styles.itemTwo}>
          <View style={styles.tableLeft}>
            <Text style={styles.name} numberOfLines={1} ellipsizeMode={'tail'}>
              {item.name}
            </Text>
          </View>
          <Touch style={styles.tableRight} onPress={() => this.status(item.id)}>
            <Text style={item.status ? styles.statuTrue : styles.statuFalse}>
              {item.status ? '启用' : '禁用'}
            </Text>
          </Touch>
          <Touch
            style={styles.tableRight}
            onPress={() => this.delete(item.id, item.name)}>
            <Text
              style={{
                fontSize: setSpText(40),
                color: '#fc4000',
              }}>
              删除
            </Text>
          </Touch>
        </View>
      );
    };

    const renderItem = ({item}) => <Item item={item} />;

    return (
      <View style={styles.container}>
        <Touch onPress={this.debounceFuncs} style={styles.guard}>
          <View style={styles.guard}>
            <Image
              source={require('../assets/ai/face.gif')}
              style={styles.imgs}
            />
          </View>
        </Touch>
        <Touch style={styles.tip} onPress={this.touch}>
          <View style={styles.tip}>
            <Text style={styles.tipText}>{tipText}</Text>
          </View>
        </Touch>
        <Modal
          visible={visible}
          animationType={'fade'}
          transparent
          onRequestClose={() => {
            this.setState({visible: false});
          }}>
          <View style={styles.body}>
            <Touch
              style={styles.modal}
              onPress={() => {
                this.setState({visible: false});
              }}>
              <View />
            </Touch>
            <View
              style={{
                backgroundColor: 'white',
                alignItems: 'center',
                width: '60%',
                height: scaleSize(350),
                borderRadius: scaleSize(20),
              }}>
              <View style={styles.header}>
                <Text style={styles.headerText}>请输入密码</Text>
              </View>
              <TextInput
                secureTextEntry
                autoFocus
                onChangeText={text => this.setState({inputText: text})}
                style={{
                  width: '80%',
                  height: '23%',
                  borderColor: '#fc4000',
                  borderWidth: scaleSize(1),
                  marginTop: scaleSize(30),
                  fontSize: setSpText(30),
                }}
              />
              <View
                style={{
                  backgroundColor: 'white',
                  alignItems: 'center',
                  flexDirection: 'row',
                  justifyContent: 'center',
                  marginTop: scaleSize(30),
                }}>
                <Touch
                  onPress={() => {
                    this.setState({visible: false});
                  }}>
                  <View style={styles.btnLeft}>
                    <Text style={styles.btnText}>取消</Text>
                  </View>
                </Touch>
                <Touch onPress={this.submit}>
                  <View style={styles.btnRight}>
                    <Text style={styles.btnText}>确定</Text>
                  </View>
                </Touch>
              </View>
            </View>
          </View>
        </Modal>
        <Modal
          visible={adminVisible}
          animationType={'fade'}
          transparent
          onRequestClose={() => {
            this.setState({adminVisible: false});
          }}>
          <View style={styles.body}>
            <Touch
              style={styles.modal}
              onPress={() => {
                this.setState({adminVisible: false});
              }}>
              <View />
            </Touch>
            <View
              style={{
                alignItems: 'center',
                width: '40%',
                height: scaleSize(400),
                borderRadius: scaleSize(10),
              }}>
              <Touch
                style={styles.adminsTop}
                onPress={() => {
                  this.setState({adminVisible: false, tableVisible: true});
                }}>
                <Text style={styles.texts}>管理人员</Text>
              </Touch>
              <Touch
                style={styles.admins}
                onPress={() => {
                  this.setState({adminVisible: false, orderVisible: true});
                }}>
                <Text style={styles.texts}>开门指令</Text>
              </Touch>
              <Touch
                style={styles.adminsBottom}
                onPress={() => {
                  this.setState({adminVisible: false, passwordVisible: true});
                }}>
                <Text style={styles.texts}>修改密码</Text>
              </Touch>
            </View>
          </View>
        </Modal>
        <Modal
          visible={passwordVisible}
          animationType={'fade'}
          transparent
          onRequestClose={() => {
            this.setState({passwordVisible: false});
          }}>
          <View style={styles.body}>
            <Touch style={styles.modal}>
              <View />
            </Touch>
            <View
              style={{
                backgroundColor: '#fff',
                alignItems: 'center',
                width: '70%',
                height: scaleSize(450),
                borderRadius: scaleSize(50),
              }}>
              <View style={styles.header}>
                <Text style={styles.headerText}>修改密码</Text>
              </View>
              <View style={styles.verifyPassword}>
                <Text style={styles.verifyText}>新密码:</Text>
                <TextInput
                  secureTextEntry
                  autoFocus
                  onChangeText={text => this.setState({newPassword: text})}
                  style={{
                    width: '55%',
                    height: scaleSize(80),
                    borderColor: '#fc4000',
                    borderWidth: scaleSize(1),
                    fontSize: setSpText(30),
                    marginLeft: scaleSize(60),
                  }}
                />
              </View>
              <View style={styles.verifyPassword}>
                <Text style={styles.verifyText}>确认密码:</Text>
                <TextInput
                  secureTextEntry
                  onChangeText={text => this.setState({newPasswords: text})}
                  style={{
                    width: '55%',
                    height: scaleSize(80),
                    borderColor: '#fc4000',
                    borderWidth: scaleSize(1),
                    fontSize: setSpText(30),
                    marginLeft: scaleSize(20),
                  }}
                />
              </View>
              <View
                style={{
                  backgroundColor: 'white',
                  alignItems: 'center',
                  flexDirection: 'row',
                  justifyContent: 'center',
                  marginTop: scaleSize(30),
                }}>
                <Touch
                  onPress={() => {
                    this.setState({passwordVisible: false});
                  }}>
                  <View style={styles.btnLeft}>
                    <Text style={styles.btnText}>取消</Text>
                  </View>
                </Touch>
                <Touch onPress={this.verify}>
                  <View style={styles.btnRight}>
                    <Text style={styles.btnText}>确定</Text>
                  </View>
                </Touch>
              </View>
            </View>
          </View>
        </Modal>
        <Modal
          visible={orderVisible}
          animationType={'fade'}
          transparent
          onRequestClose={() => {
            this.setState({orderVisible: false});
          }}>
          <View style={styles.body}>
            <Touch style={styles.modal}>
              <View />
            </Touch>
            <View
              style={{
                backgroundColor: 'white',
                alignItems: 'center',
                width: '60%',
                height: scaleSize(350),
                borderRadius: scaleSize(20),
              }}>
              <View style={styles.header}>
                <Text style={styles.headerText}>开门指令</Text>
              </View>
              <TextInput
                autoFocus
                onChangeText={text => this.setState({order: text})}
                value={order}
                style={{
                  width: scaleSize(500),
                  height: scaleSize(80),
                  borderColor: '#fc4000',
                  borderWidth: scaleSize(1),
                  marginTop: scaleSize(30),
                  fontSize: setSpText(30),
                }}
              />
              <View
                style={{
                  backgroundColor: 'white',
                  alignItems: 'center',
                  flexDirection: 'row',
                  justifyContent: 'center',
                  marginTop: scaleSize(30),
                }}>
                <Touch
                  onPress={() => {
                    this.setState({orderVisible: false});
                  }}>
                  <View style={styles.btnLeft}>
                    <Text style={styles.btnText}>取消</Text>
                  </View>
                </Touch>
                <Touch onPress={this.order}>
                  <View style={styles.btnRight}>
                    <Text style={styles.btnText}>确定</Text>
                  </View>
                </Touch>
              </View>
            </View>
          </View>
        </Modal>
        <Modal
          visible={tableVisible}
          animationType={'fade'}
          transparent
          onRequestClose={() => {
            this.setState({tableVisible: false});
          }}>
          <View style={styles.body}>
            <Touch style={styles.modal}>
              <View />
            </Touch>
            <View
              style={{
                backgroundColor: 'white',
                alignItems: 'center',
                width: '80%',
                height: scaleSize(1500),
                borderRadius: scaleSize(20),
              }}>
              <View style={styles.header}>
                <Text style={styles.headerText}>管理人员</Text>
              </View>
              <View style={styles.list}>
                <View style={styles.item}>
                  <View style={styles.tableLeft}>
                    <Text style={styles.title}>昵称</Text>
                  </View>
                  <View style={styles.tableRight}>
                    <Text style={styles.title}>状态</Text>
                  </View>
                  <View style={styles.tableRight}>
                    <Text style={styles.title}>操作</Text>
                  </View>
                </View>
                <FlatList
                  data={datas}
                  renderItem={renderItem}
                  keyExtractor={item => item.key}
                />
              </View>
              <View
                style={{
                  backgroundColor: 'white',
                  alignItems: 'center',
                  flexDirection: 'row',
                  justifyContent: 'center',
                  marginBottom: scaleSize(30),
                  marginTop: scaleSize(30),
                }}>
                <Touch
                  onPress={() => {
                    this.setState({tableVisible: false});
                  }}>
                  <View style={styles.btnLeft}>
                    <Text style={styles.btnText}>关闭</Text>
                  </View>
                </Touch>
                <Touch onPress={this.table}>
                  <View style={styles.tableBtnRight}>
                    <Text style={styles.btnText}>添加</Text>
                  </View>
                </Touch>
              </View>
            </View>
          </View>
        </Modal>
        <Modal
          visible={delVisible}
          animationType={'fade'}
          transparent
          onRequestClose={() => {
            this.setState({delVisible: false});
          }}>
          <View style={styles.body}>
            <Touch style={styles.modal}>
              <View />
            </Touch>
            <View
              style={{
                backgroundColor: 'white',
                alignItems: 'center',
                width: '60%',
                height: '14%',
                borderRadius: scaleSize(20),
              }}>
              <View style={styles.header}>
                <Text
                  numberOfLines={1}
                  ellipsizeMode={'tail'}
                  style={{
                    color: '#fff',
                    fontSize: setSpText(40),
                  }}>
                  您确定要删除{name}吗
                </Text>
              </View>
              <View
                style={{
                  backgroundColor: 'white',
                  alignItems: 'center',
                  flexDirection: 'row',
                  justifyContent: 'center',
                  marginBottom: scaleSize(30),
                  marginTop: scaleSize(30),
                }}>
                <Touch
                  onPress={() => {
                    this.setState({delVisible: false});
                  }}>
                  <View style={styles.btnLeft}>
                    <Text style={styles.btnText}>取消</Text>
                  </View>
                </Touch>
                <Touch onPress={this.reamove}>
                  <View style={styles.tableBtnRight}>
                    <Text style={styles.btnText}>确定</Text>
                  </View>
                </Touch>
              </View>
            </View>
          </View>
        </Modal>
      </View>
    );
  }
}

const styles = {
  body: {
    width: '100%',
    height: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    position: 'relative',
  },
  modal: {
    width: '100%',
    height: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'rgba(0,0,0,0.5)',
    position: 'absolute',
  },
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'black',
  },
  tip: {
    position: 'absolute',
    flexDirection: 'row',
    bottom: 0,
    width: '100%',
    height: scaleSize(100),
    backgroundColor: '#FC4000',
    justifyContent: 'center',
    alignItems: 'center',
  },
  tipText: {
    color: 'white',
    fontSize: setSpText(40),
  },
  guard: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'black',
  },
  imgs: {
    width: 800,
    height: 800,
  },
  header: {
    width: '100%',
    height: scaleSize(80),
    backgroundColor: '#fc4000',
    justifyContent: 'center',
    alignItems: 'center',
    borderTopLeftRadius: scaleSize(20),
    borderTopRightRadius: scaleSize(20),
  },
  headerText: {
    color: '#fff',
    fontSize: setSpText(50),
  },
  btnText: {
    color: '#fff',
    fontSize: setSpText(30),
  },
  btnLeft: {
    width: scaleSize(200),
    height: scaleSize(80),
    backgroundColor: '#23aaf1',
    alignItems: 'center',
    flexDirection: 'row',
    justifyContent: 'center',
    borderRadius: scaleSize(10),
  },
  btnRight: {
    width: scaleSize(200),
    height: scaleSize(80),
    backgroundColor: '#fc4000',
    alignItems: 'center',
    flexDirection: 'row',
    justifyContent: 'center',
    borderRadius: scaleSize(10),
    marginLeft: scaleSize(30),
  },
  tableBtnRight: {
    width: scaleSize(200),
    height: scaleSize(80),
    backgroundColor: '#fc4000',
    alignItems: 'center',
    flexDirection: 'row',
    justifyContent: 'center',
    borderRadius: scaleSize(10),
    marginLeft: scaleSize(150),
  },
  texts: {
    color: '#fff',
    fontSize: setSpText(30),
  },
  admins: {
    height: '33.33%',
    width: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#fc4000',
    borderBottomColor: '#fff',
    borderBottomWidth: scaleSize(1),
  },
  adminsTop: {
    height: '33.33%',
    width: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#fc4000',
    borderBottomColor: '#fff',
    borderBottomWidth: scaleSize(1),
    borderTopLeftRadius: scaleSize(20),
    borderTopRightRadius: scaleSize(20),
  },
  adminsBottom: {
    height: '33.33%',
    width: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#fc4000',
    borderBottomLeftRadius: scaleSize(20),
    borderBottomRightRadius: scaleSize(20),
  },
  verifyPassword: {
    width: '100%',
    height: scaleSize(80),
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: scaleSize(30),
  },
  verifyText: {
    fontSize: setSpText(40),
  },
  list: {
    width: '100%',
    height: scaleSize(1250),
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'flex-start',
  },
  item: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  title: {
    fontSize: setSpText(40),
  },
  tableLeft: {
    alignItems: 'center',
    justifyContent: 'center',
    width: scaleSize(470),
  },
  tableRight: {
    alignItems: 'center',
    justifyContent: 'center',
    width: scaleSize(200),
  },
  itemOne: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#ddd',
    height: scaleSize(100),
  },
  itemTwo: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#fff',
    height: scaleSize(100),
  },
  statuTrue: {
    borderRadius: scaleSize(5),
    backgroundColor: '#16ea0e',
    color: '#fff',
    fontSize: setSpText(40),
    paddingLeft: scaleSize(30),
    paddingRight: scaleSize(30),
    paddingTop: scaleSize(10),
    paddingBottom: scaleSize(10),
  },
  statuFalse: {
    borderRadius: scaleSize(5),
    backgroundColor: '#f80351',
    color: '#fff',
    fontSize: setSpText(40),
    paddingLeft: scaleSize(30),
    paddingRight: scaleSize(30),
    paddingTop: scaleSize(10),
    paddingBottom: scaleSize(10),
  },
  name: {
    width: scaleSize(300),
    textAlign: 'center',
    fontSize: setSpText(40),
  },
};

export default connect(({store}) => ({store}))(GuardPage);
