import React, {Component} from 'react';
import {View, Text, Image, Modal, ScrollView} from 'react-native';
import AsyncStorage from '@react-native-community/async-storage';
import Swiper from 'react-native-swiper';
import QRCode from 'react-native-qrcode-svg';
import Icon from 'react-native-vector-icons/Ionicons';
import Icons from 'react-native-vector-icons/MaterialIcons';
import CounterMixins from './CounterMixins';
import NP from '../utils/np';
import AutoClick from '../utils/AutoClick';
import Touch from '../components/Touch';
import ModalView from '../components/ModalView';
import counterText from '../assets/Vertical/counterText.png';
import img24h from '../assets/Vertical/24h.png';
import phone from '../assets/Vertical/phone.png';
import guide from '../assets/Vertical/guide.jpg';
import call from '../assets/Vertical/call.png';
import {login} from '../utils/config';
import {colors} from '../utils/common';
import WxFacepay from '../utils/WxFacepay';
import {
  width,
  setSpText,
  scaleSize,
  scaleHeight,
  // height,
} from '../utils/screen';
import Speech from '../utils/Speech';
import delay from '../utils/delay';
import Printer from '../utils/Printer';
import Smilepay from '../utils/Smilepay';
import {leaveTalkCall, onTalkCall} from '../utils/agora';
import Toast from '../components/Toast';
import {ossLink} from '../utils/config';

let pageSize = 8; // 分页大小
window.pageSize = pageSize;

// const wait = t => new Promise(resolve => setTimeout(resolve, t));

class VerticalPage extends Component {
  state = {
    contact: '',
    maskVisible: true,
    visibleActive: false,
    talkCall: 2, // 0请求通话，1通话中，2，已挂断通话，待机状态
    faceType: 'wxpay',
    hintVisible: false,
    setting: false,
    logoVisible: true,
    logo: '',
    priceVisible: true,
    isCard: false,
    cardVisible: false,
  };

  async componentWillMount() {
    let stype = await AsyncStorage.getItem('STYPE');
    let contact = await AsyncStorage.getItem('CONTACT');
    // let lock = await AsyncStorage.getItem('settingLock');
    // if (lock) this.props.dispatch({ type: 'app/lock', lock });
    this.setState({stype, contact});
    this.storeKey = await AsyncStorage.getItem('KEY');
    if (!this.init) {
      this.init = await WxFacepay.initialize(10000);
      if (!this.init) {
        // 微信刷脸失败，启动支付宝刷脸
        this.init = true;
        this.setState({faceType: 'alipay'});
      } else {
        const getAuth = async () => {
          const auth = await this.authinfo();
          if (!this.rawinfo) this.rawinfo = {};
          if (auth) this.rawinfo = auth;
        };
        getAuth();
        clearInterval(this.rawinfoInterval);
        this.rawinfoInterval = setInterval(getAuth, 30 * 60 * 1000);
      }
    }
    this.initSetting();
    AutoClick.on('wxpayfaceRegister', async () => {
      await AutoClick.clickBackKey();
      if (this.faceBusy) return;
      this.faceBusy = true;
      await this.wxFacepay(); // 点击开通重新调用
      this.faceBusy = false;
    });
    await this.refreshLogo();
  }

  initSetting = () => {
    AutoClick.isSettingsOn().then(setting => {
      if (!setting) this.setState({setting: true}); // 展示辅助按钮
    });
    AsyncStorage.getItem('hideLogo').then(hide => {
      if (hide === 'true') this.setState({logoVisible: false}); // 隐藏LOGO
    });
  };

  setting = async () => {
    await AutoClick.goSetting(); // 按钮跳转设置
  };

  async componentDidMount() {
    this.listen();
  }

  listen = async () => {
    try {
      while (!window.socket) {
        await delay(1000);
      }
      if (!window.socket.hasListeners('talkCall')) {
        // 语音通话中
        window.socket.on('talkCall', this.handleTalkCall);
      }
      if (!window.socket.hasListeners('talkLeave')) {
        // 语音通话中
        window.socket.on('talkLeave', this.leaveC);
      }

      // logo改变
      if (!window.socket.hasListeners('storeSetting')) {
        window.socket.on('storeSetting', async ({logo, priceVisible}) => {
          // 重新获取logo
          if (logo) {
            await this.setState({logo: `${ossLink}/${logo}`});
          }
          await this.setState({priceVisible});
        });
      }

      // 外卖自提订单小票打印
      if (!window.socket.hasListeners('orderReceipt')) {
        window.socket.on('orderReceipt', async data => {
          await this.print(data.goods, data.receipt);
        });
      }
    } catch (e) {
      console.log(e);
    }
  };

  refreshLogo = async () => {
    let group = await AsyncStorage.getItem('KEY');
    let {data} = await this.props.dispatch({
      type: 'store/findModuleSetting',
      group,
    });
    if (data.code === 1 && data.data) {
      const state = {priceVisible: data.data.priceVisible};
      if (data.data.cardCounter) {
        // 是否支持刷卡
        state.isCard = true;
        window.cardCounter = data.data.cardCounter;
      }
      if (data.data.logo) state.logo = `${ossLink}/${data.data.logo}`;
      this.setState(state);
    }
  };

  print = async (arr, receipt) => {
    let total = 0;
    let goods = [];
    arr.map(v => {
      total += (v.price > 0 ? v.price : v.prePrice) * v.num;
      goods.push(
        `${v.name},${v.num},${v.price > 0 ? v.price : v.prePrice},${(v.price > 0
          ? v.price
          : v.prePrice) * v.num}`,
      );
    });
    goods.push(`总计, , ,${total.toFixed(2)}`);
    await Printer.printNote(goods, receipt);
  };

  handleTalkCall = async () => {
    try {
      // 加入语音通话
      clearInterval(this.noTalkCall);
      clearInterval(this.callTimeout);
      const {data} = await this.props.dispatch({
        type: 'agora/agora',
      });
      await onTalkCall(data);
      clearTimeout(this.onCallTimeout);
      this.onCallTimeout = setTimeout(() => {
        this.leaveC();
      }, 5 * 60 * 1000);
      this.setState({
        talkCall: 1,
      });
    } catch (e) {
      console.log(e);
    }
  };

  leaveC = async () => {
    try {
      clearInterval(this.noTalkCall);
      clearInterval(this.callTimeout);
      await leaveTalkCall;
      await this.props.dispatch({
        type: 'agora/talkLeave',
      });
      this.setState({
        talkCall: 2,
      });
    } catch (e) {
      console.log(e);
    }
  };

  alipayinfo = async () => {
    const {data} = await this.props.dispatch({type: 'goods/alipayinfo'});
    this.alipayInfo = await Smilepay.init(data);
    if (this.alipayInfo.code === '1000')
      this.alipayInfo.metaInfo = JSON.parse(this.alipayInfo.metaInfo);
    return this.alipayInfo;
  };

  authinfo = async () => {
    const rawdata = await WxFacepay.rawdata();
    const {data} = await this.props.dispatch({type: 'goods/faceinfo', rawdata});
    if (data.code !== 1) {
      return null;
    }
    return data.data;
  };

  // 生成不重复的key
  keyExtractor = (item: any, index: number) => {
    return String(index);
  };

  // stepOne = async () => {
  //   await this.setState({
  //     visibleActive: true,
  //   });
  //   setTimeout(() => {
  //     this.setState({
  //       visibleActive: false,
  //     });
  //   }, 3000);
  // };
  //
  // stepTwo = () => {
  //   let {visibleActive} = this.state;
  //   if (visibleActive) {
  //     this.setState({
  //       maskVisible: false,
  //     });
  //     setTimeout(() => {
  //       this.setState({
  //         visibleActive: false,
  //         maskVisible: true,
  //       });
  //     }, 5000);
  //   }
  // };

  wxFacepay = async () => {
    const {goodsArr} = this.props;
    if (goodsArr.length === 0) {
      this.props.speak('请先扫描商品条码，再刷脸支付', true);
      return;
    }
    const auth = this.rawinfo;
    let params = null;
    if (auth.bizCode === '0000') {
      // 随行付支付
      params = {
        appid: auth.subAppId,
        mch_id: auth.subMchId,
        store_id: this.storeKey,
        authinfo: auth.authInfo,
        ask_face_permit: 1,
        face_code_type: '1',
      };
    } else if (auth.sub_mchid_info) {
      // 扫呗支付
      const info = JSON.parse(auth.sub_mchid_info);
      params = {
        appid: info.sub_serv_appid,
        mch_id: info.sub_serv_no,
        store_id: this.storeKey,
        authinfo: auth.authinfo,
        face_authtype: 'FACEPAY',
        sub_appid: info.sub_appid,
        sub_mch_id: info.sub_mch_id,
        out_trade_no: auth.out_trade_no,
        ask_face_permit: 1,
        face_code_type: auth.auth_no_type,
      };
    }
    if (!params) {
      if (this.faceRetry) {
        this.faceRetry = false;
        this.props.speak('刷脸支付启动失败，请重新刷脸或扫码支付', true);
      } else {
        this.faceRetry = true;
        this.wxFacepay(); // 重试一次
      }
      return;
    }
    let res = await WxFacepay.facepay(params);
    if (!res && !AutoClick.enable) {
      // 返回错误自动重新识别
      res = await WxFacepay.facepay(params);
    }
    if (res.face_code) {
      const data = await this.props.balancePay(res.sub_openid);
      if (data.code !== 1) {
        await this.props.barcodepay(res.face_code, true, res.sub_openid);
      }
      this.faceRetry = false;
    }
  };

  smilepay = async () => {
    const {goodsArr} = this.props;
    if (goodsArr.length === 0) {
      this.props.speak('请先扫描商品条码，再刷脸支付', true);
      return;
    }
    await this.alipayinfo();
    if (!this.alipayInfo || !this.alipayInfo.metaInfo) {
      this.props.speak('刷脸支付启动失败，请重新刷脸或扫码支付', true);
      return;
    }
    const {data} = await this.props.dispatch({
      type: 'goods/smilepay',
      zimmetainfo: this.alipayInfo.metaInfo,
    });
    if (data.code === 1) {
      const res = await Smilepay.verify(JSON.parse(data.data));
      if (res.code !== '1000') {
        Toast.show(res.msg);
        return;
      }
      const balanceData = await this.props.balancePay(res.uid);
      if (balanceData.code !== 1) {
        await this.props.barcodepay(
          res.fToken,
          true,
          null,
          res.fToken,
          res.uid,
        );
      }
      // await this.props.barcodepay(res.fToken, true, null, res.fToken, res.uid);
    }
  };

  onCall = async () => {
    const {talkCall} = this.state;
    if (talkCall === 2) {
      Speech.speak('正在接通中请稍候');
      this.talkCall();
      clearInterval(this.noTalkCall);
      this.noTalkCall = setInterval(() => this.talkCall(), 10000);
      this.setState({
        talkCall: 0,
      });
      clearInterval(this.callTimeout);
      this.callTimeout = setTimeout(() => {
        clearInterval(this.noTalkCall);
        this.setState({
          talkCall: 2,
        });
      }, 30000);
    }
    this.setState({
      hintVisible: true,
    });
    clearTimeout(this.callModalTimeout);
    this.callModalTimeout = setTimeout(() => {
      this.setState({hintVisible: false});
    }, 300000);
  };

  onNoBuy = async () => {
    const {data} = await this.props.dispatch({type: 'store/noBuyGoGoGo'});
    Speech.speak(data.msg);
  };

  closeHint = () => {
    this.setState({
      hintVisible: false,
    });
  };

  talkCall = () => {
    this.props.dispatch({
      type: 'agora/talkCall',
    });
  };

  renderHeader = () => {
    return (
      <View style={{flex: 1, flexDirection: 'column'}}>
        <View style={{backgroundColor: '#fff'}}>
          <View
            style={{
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'center',
            }}>
            <View style={styles.firstThStyle}>
              <Text style={styles.ThText}>商品名称</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>单价</Text>
            </View>
            <View style={styles.ThStyle}>
              <Text style={styles.ThText}>数量</Text>
            </View>
            <View style={styles.ThStyleMoney}>
              <Text style={styles.ThText}>金额</Text>
            </View>
            <View />
          </View>
        </View>
        <View
          style={{
            height: width > 801 ? 20 : scaleHeight(30),
            backgroundColor: '#F0F0F0',
          }}
        />
      </View>
    );
  };

  // 显示数据
  renderCell = (item, index) => (
    <View style={index % 2 === 0 ? styles.oddCell : styles.evenCell}>
      <View style={styles.firstTdStyle}>
        <Text style={styles.TdText} numberOfLines={1}>
          {item.spec ? `${item.name}(${item.spec})` : item.name}
        </Text>
      </View>
      <View style={styles.TdStyle}>
        {item.price ? (
          // <Text style={styles.TdText}>
          //   {' '}
          //   ￥{NP.round(item.price, 2).toFixed(2)}/{item.unit}{' '}
          // </Text>
          <View
            style={{
              justifyContent: 'center',
              alignItems: 'center',
              flexDirection: 'row',
            }}>
            <Text
              style={{
                fontSize: 20,
                textDecorationLine: 'line-through',
                color: '#999999',
                marginRight: 5,
              }}>
              ￥{NP.round(item.prePrice, 2).toFixed(2)}
            </Text>
            {item.unit ? (
              <Text style={{fontSize: 25, color: colors.textXSActive}}>
                ￥{NP.round(item.price, 2).toFixed(2)}/
                <Text style={styles.TdText}>{item.unit}</Text>
              </Text>
            ) : (
              <Text style={{fontSize: 25, color: colors.textXSActive}}>
                ￥{NP.round(item.price, 2).toFixed(2)}
              </Text>
            )}
          </View>
        ) : (
          <View
            style={{
              justifyContent: 'center',
              alignItems: 'center',
              flexDirection: 'row',
            }}>
            {item.unit ? (
              <Text style={styles.TdText}>
                ￥{NP.round(item.prePrice, 2).toFixed(2)}/{item.unit}
              </Text>
            ) : (
              <Text style={styles.TdText}>
                ￥{NP.round(item.prePrice, 2).toFixed(2)}
              </Text>
            )}
          </View>
        )}
      </View>
      <View style={styles.TdStyle}>
        {item.numChange ? (
          <Icon
            onPress={() => this.props.numRemove(item.num, index)}
            name="ios-remove-circle"
            color={item.num === 1 ? '#909090' : '#00c670'}
            size={35}
          />
        ) : (
          <View />
        )}
        <Touch
          viewWrap={false}
          onPress={() => item.numChange && this.props.numChange(index)}>
          <Text style={styles.TdText}> {item.num} </Text>
        </Touch>
        {item.numChange ? (
          <Icon
            name="ios-add-circle"
            color="#00c670"
            size={35}
            onPress={() => this.props.numAdd(item.num, index)}
          />
        ) : (
          <View />
        )}
      </View>
      <View style={styles.TdStyleMoney}>
        {item.price ? (
          <Text style={styles.TdText}>
            {NP.round(item.price * item.num, 2).toFixed(2)}
          </Text>
        ) : (
          <Text style={styles.TdText}>
            {NP.round(item.prePrice * item.num, 2).toFixed(2)}
          </Text>
        )}
        <View style={styles.iconStyle}>
          <Icon
            style={{marginLeft: 0}}
            name="ios-close-circle"
            size={35}
            color={colors.bg}
            onPress={() => this.props.removeIndex(index)}
          />
        </View>
      </View>
    </View>
  );

  hideLogo = async () => {
    if (!this.num) this.num = 0;
    this.num++;
    if (this.num >= 10) {
      this.num = 0;
      let {logoVisible} = this.state;
      AsyncStorage.setItem('hideLogo', String(logoVisible));
      this.setState({
        logoVisible: !logoVisible,
      });
    }
  };

  cardPayPay = async () => {
    const {goodsArr} = this.props;
    if (goodsArr.length === 0) {
      this.props.speak('请先扫描商品条码，再刷卡付款', true);
      return;
    }
    Speech.speak('请刷卡付款');
    this.props.dispatch({
      type: 'goods/cardVisible',
      visible: true,
    });
    setTimeout(() => {
      this.props.dispatch({
        type: 'goods/cardVisible',
        visible: false,
      });
    }, 8000);
  };

  render() {
    let {
      admin,
      goods,
      goodsArr,
      qrHost,
      autoplayTime,
      imgArr,
      adType,
    } = this.props;
    let {
      contact,
      hintVisible,
      logoVisible,
      logo,
      priceVisible,
      stype,
      isCard,
    } = this.state;
    pageSize =
      goods && goods.bags.length > 0
        ? goods && goods.bags.length > 3
          ? 6
          : 7
        : pageSize;
    let bagsData = [];
    if (goods && goods.bags) {
      let num = Math.ceil(goods.bags.length / 3);
      for (let i = 0; i < num; i++) {
        if (i < 2) {
          bagsData.push(goods.bags.slice(i * 3, i * 3 + 3));
        }
      }
    }
    window.pageSize = pageSize;
    contact = contact || '未授权';
    // let goodsLength = Math.ceil(parseFloat(goodsArr.length / pageSize));
    // let gaTemp = goodsArr.slice((current - 1) * pageSize, current * pageSize);
    let total = 0; // 总数量
    let totalPrice = 0; // 总价
    let totalCount = 0; // 总优惠
    goodsArr.map(item => {
      total += item.num;
      if (item.price) {
        totalPrice += item.price * item.num;
        totalCount += (item.prePrice - item.price) * item.num;
      } else {
        totalPrice += item.prePrice * item.num;
      }
    });
    this.totalPrice = totalPrice;
    this.totalCount = totalCount;
    if (this.state.faceType === 'alipay')
      styles.guide = {...styles.guide, backgroundColor: '#1b7dc7'};
    const facepay =
      this.state.faceType === 'wxpay' ? this.wxFacepay : this.smilepay;
    return (
      <View style={{flex: 1, position: 'relative'}}>
        <View style={styles.main}>
          {goodsArr.length === 0 && stype === 'guard' ? (
            <View style={styles.guardModal}>
              <View style={styles.guardModal_image}>
                <Image style={styles.Imageee} source={guide} />
              </View>
              <View style={styles.guardModal_button}>
                <Touch onPress={() => this.onCall()}>
                  <View style={styles.guardModal_button_call}>
                    <Text style={styles.callText}>呼叫客服</Text>
                  </View>
                </Touch>
                <Touch onPress={() => this.onNoBuy()}>
                  <View style={styles.guardModal_button_nobuy}>
                    <Text style={styles.callText}>无购物出店</Text>
                  </View>
                </Touch>
              </View>
            </View>
          ) : null}
          <HintPhone
            visible={hintVisible}
            contact={contact}
            closeHint={this.closeHint}
          />
          <View style={styles.header}>
            <View style={styles.left}>
              {logoVisible &&
                (logo ? (
                  <Image style={styles.logo} source={{uri: logo}} />
                ) : (
                  <Image
                    style={styles.logo}
                    source={require('../assets/Vertical/logo.png')}
                  />
                ))}
              <Image style={styles.counterText} source={counterText} />
              <Image source={img24h} />
            </View>
            <Touch onPress={() => this.onCall()} style={{marginLeft: 50}}>
              <View style={styles.right}>
                <Image style={styles.phone} source={phone} />
                <Text style={styles.number}>呼叫客服</Text>
              </View>
            </Touch>
          </View>
          <View
            style={{
              ...styles.container,
              height: width > 801 && !isCard ? '62%' : '94%',
            }}>
            <View style={{flexDirection: 'row', flex: 1}}>
              <View style={{width: '100%'}}>
                <View style={{backgroundColor: '#fff'}}>
                  <View
                    style={{
                      flexDirection: 'row',
                      alignItems: 'center',
                      justifyContent: 'center',
                    }}>
                    <View style={styles.firstThStyle}>
                      <Text style={styles.ThText}>商品名称</Text>
                    </View>
                    <View style={styles.ThStyle}>
                      <Text style={styles.ThText}>单价</Text>
                    </View>
                    <View style={styles.ThStyle}>
                      <Text style={styles.ThText}>数量</Text>
                    </View>
                    <View style={styles.ThStyleMoney}>
                      <Text style={styles.ThText}>金额</Text>
                    </View>
                    <View />
                  </View>
                </View>
                <ScrollView
                  onContentSizeChange={() =>
                    this.ref.scrollToEnd({animated: false})
                  }
                  ref={ref => (this.ref = ref)}>
                  {goodsArr.map((item, index) => {
                    return (
                      <View
                        key={index}
                        style={
                          index % 2 === 0 ? styles.evenCell : styles.oddCell
                        }>
                        <View style={styles.firstTdStyle}>
                          <Text style={styles.TdText} numberOfLines={1}>
                            {item.spec
                              ? `${item.name}(${item.spec})`
                              : item.name}
                          </Text>
                        </View>
                        <View style={styles.TdStyle}>
                          {item.price ? (
                            // <Text style={styles.TdText}>
                            //   {' '}
                            //   ￥{NP.round(item.price, 2).toFixed(2)}/{item.unit}{' '}
                            // </Text>
                            <View
                              style={{
                                justifyContent: 'center',
                                alignItems: 'center',
                                flexDirection: 'row',
                              }}>
                              <Text
                                style={{
                                  fontSize: 20,
                                  textDecorationLine: 'line-through',
                                  color: '#999999',
                                  marginRight: 5,
                                }}>
                                ￥{NP.round(item.prePrice, 2).toFixed(2)}
                              </Text>
                              {item.unit ? (
                                <Text
                                  style={{
                                    fontSize: 25,
                                    color: colors.textXSActive,
                                  }}>
                                  ￥{NP.round(item.price, 2).toFixed(2)}/
                                  <Text style={styles.TdText}>{item.unit}</Text>
                                </Text>
                              ) : (
                                <Text
                                  style={{
                                    fontSize: 25,
                                    color: colors.textXSActive,
                                  }}>
                                  ￥{NP.round(item.price, 2).toFixed(2)}
                                </Text>
                              )}
                            </View>
                          ) : (
                            <View
                              style={{
                                justifyContent: 'center',
                                alignItems: 'center',
                                flexDirection: 'row',
                              }}>
                              {item.unit ? (
                                <Text style={styles.TdText}>
                                  ￥{NP.round(item.prePrice, 2).toFixed(2)}/
                                  {item.unit}
                                </Text>
                              ) : (
                                <Text style={styles.TdText}>
                                  ￥{NP.round(item.prePrice, 2).toFixed(2)}
                                </Text>
                              )}
                            </View>
                          )}
                        </View>
                        <View style={styles.TdStyle}>
                          {item.numChange ? (
                            <Icon
                              onPress={() =>
                                this.props.numRemove(item.num, index)
                              }
                              name="ios-remove-circle"
                              color={item.num === 1 ? '#909090' : '#00c670'}
                              size={35}
                            />
                          ) : (
                            <View />
                          )}
                          <Touch
                            viewWrap={false}
                            onPress={() =>
                              item.numChange && this.props.numChange(index)
                            }>
                            <Text style={styles.TdText}> {item.num} </Text>
                          </Touch>
                          {item.numChange ? (
                            <Icon
                              name="ios-add-circle"
                              color="#00c670"
                              size={35}
                              onPress={() => this.props.numAdd(item.num, index)}
                            />
                          ) : (
                            <View />
                          )}
                        </View>
                        <View style={styles.TdStyleMoney}>
                          {item.price ? (
                            <Text style={styles.TdText}>
                              {NP.round(item.price * item.num, 2).toFixed(2)}
                            </Text>
                          ) : (
                            <Text style={styles.TdText}>
                              {NP.round(item.prePrice * item.num, 2).toFixed(2)}
                            </Text>
                          )}
                          <View style={styles.iconStyle}>
                            <Icon
                              style={{marginLeft: 0}}
                              name="ios-close-circle"
                              size={35}
                              color={colors.bg}
                              onPress={() => this.props.removeIndex(index)}
                            />
                          </View>
                        </View>
                      </View>
                    );
                  })}
                </ScrollView>
                {/*<FlatList*/}
                {/*  style={styles.goodsStyle}*/}
                {/*  ListHeaderComponent={this.renderHeader}*/}
                {/*  keyExtractor={this.keyExtractor}*/}
                {/*  horizontal={false}*/}
                {/*  data={goodsArr}*/}
                {/*  renderItem={({item, index}) => this.renderCell(item, index)}*/}
                {/*/>*/}
              </View>
            </View>
            <View
              style={
                goods && goods.bags.length > 0
                  ? styles.btnLowStyle
                  : styles.btnHighStyle
              }>
              {!admin.autoClick && (
                <Touch
                  onPress={this.setting}
                  style={{
                    position: 'absolute',
                    width: scaleSize(100),
                    height: scaleSize(100),
                    top: 0,
                    right: 0,
                    backgroundColor: 'rgba(0,0,0,0.1)',
                    alignItems: 'center',
                    justifyContent: 'center',
                    borderRadius: 10,
                    zIndex: 999,
                  }}>
                  <Icons
                    name="accessibility"
                    style={{fontSize: setSpText(60), color: '#fff'}}
                  />
                </Touch>
              )}
              <Touch
                onPress={() => this.props.handleBarcode()}
                style={{backgroundColor: '#fc4000', marginRight: 50}}>
                <Text style={styles.btnText}>输入条码</Text>
              </Touch>
              {priceVisible && (
                <Touch
                  onPress={() => this.props.handleCodeless()}
                  style={{
                    backgroundColor: '#fc4000',
                    marginRight: 50,
                    marginLeft: 50,
                  }}>
                  <Text style={styles.btnText}>输入价格</Text>
                </Touch>
              )}
              <Touch
                onPress={this.props.clearList}
                style={{backgroundColor: '#fc4000', marginLeft: 50}}>
                <Text style={styles.btnText}>清除商品</Text>
              </Touch>
            </View>
            {bagsData.map((v1, k) => {
              return (
                <View
                  key={k}
                  style={goods.bags.length <= 3 ? styles.bag : styles.bagMore}>
                  {v1.map((v2, i) => {
                    return (
                      <Touch key={i} onPress={() => this.props.pushBag(i)}>
                        <View style={styles.btnBag}>
                          <Image
                            source={require('../assets/Vertical/buy.png')}
                            style={styles.btnImage}
                          />
                          <Text style={styles.textBag}>{v2.name}</Text>
                          <Text style={styles.textBag}>{v2.price}</Text>
                        </View>
                      </Touch>
                    );
                  })}
                </View>
              );
            })}
            {/*<View style={styles.bag}>*/}
            {/*  {goods.bags.map((v, k) => {*/}
            {/*    return (*/}
            {/*      <Touch key={k} onPress={() => this.props.pushBag(k)}>*/}
            {/*        <View style={styles.btnBag}>*/}
            {/*          <Image*/}
            {/*            source={require('../assets/Vertical/buy.png')}*/}
            {/*            style={styles.btnImage}*/}
            {/*          />*/}
            {/*          <Text style={styles.textBag}>{v.name}</Text>*/}
            {/*          <Text style={styles.textBag}>{v.price}</Text>*/}
            {/*        </View>*/}
            {/*      </Touch>*/}
            {/*    );*/}
            {/*  })}*/}
            {/*</View>*/}
            <View style={styles.shadow} />
            <Touch onPress={isCard ? this.cardPayPay : facepay}>
              <View style={styles.guide}>
                <Text style={styles.guideText}>点击进入</Text>
                <Image
                  source={require('../assets/down.png')}
                  style={styles.down}
                />
                <Text style={styles.guideText}>
                  {isCard ? '刷卡支付' : '人脸支付'}
                </Text>
              </View>
            </Touch>
            <View style={styles.payment}>
              <View style={styles.paymentLeft}>
                <View style={styles.barcode}>
                  <Text style={styles.leftText1}>合计:</Text>
                  <Text style={styles.leftText1}>数量:</Text>
                  <Text style={styles.leftText1}>优惠:</Text>
                  <View style={styles.leftLine1} />
                  <Text style={styles.leftText1}>金额:</Text>
                </View>
                <View style={styles.amount}>
                  <Text style={styles.leftText2}>
                    {NP.round(
                      Number(totalPrice) + Number(totalCount),
                      2,
                    ).toFixed(2)}
                  </Text>
                  <Text style={styles.leftText2}>
                    {NP.round(total, 2).toFixed(2)}
                  </Text>
                  <Text style={styles.leftText2}>
                    -{NP.round(totalCount, 2).toFixed(2)}
                  </Text>
                  <View style={styles.leftLine2} />
                  <Text style={styles.total}>
                    {NP.round(totalPrice, 2).toFixed(2)}
                  </Text>
                </View>
              </View>
              <View style={styles.faceScan}>
                <Touch onPress={isCard ? this.cardPayPay : facepay}>
                  <View>
                    {isCard ? (
                      <Image
                        source={require('../assets/Vertical/card.png')}
                        alt=""
                      />
                    ) : (
                      <Image
                        source={require('../assets/Vertical/face.gif')}
                        style={styles.faceGif}
                        alt=""
                      />
                    )}
                    <View style={styles.facePay}>
                      {!isCard && (
                        <Image
                          source={
                            this.state.faceType === 'wxpay'
                              ? require('../assets/Vertical/wxpay.png')
                              : require('../assets/Vertical/alipay01.png')
                          }
                          style={styles.payImage}
                          alt=""
                        />
                      )}
                      <Text style={styles.payText}>
                        {isCard ? '点击刷卡支付' : '点击刷脸支付'}
                      </Text>
                    </View>
                  </View>
                </Touch>
              </View>
              <View style={styles.paymentRight}>
                {isCard ? (
                  <Image
                    style={{width: scaleSize(200), height: scaleSize(200)}}
                    source={require('../assets/logo2.png')}
                  />
                ) : (
                  <View style={styles.paymentRightTitle}>
                    <View style={styles.paymentRightContents}>
                      <Text style={styles.paymentRightText}>扫码</Text>
                      <Text style={styles.paymentRightText}>支付</Text>
                      <Image
                        source={require('../assets/Vertical/alipay01.png')}
                        style={styles.paymentRightImage}
                        alt=""
                      />
                      <Image
                        source={require('../assets/Vertical/wx.png')}
                        style={styles.paymentRightImage}
                        alt=""
                      />
                    </View>
                    <View style={styles.paymentRightCode}>
                      <QRCode
                        logoSize={width > 801 ? 50 : scaleSize(60)}
                        // logoBackgroundColor="#fc4000"
                        logo={logoVisible && require('../assets/logo2.png')}
                        size={width > 801 ? 200 : scaleSize(250)}
                        value={`${qrHost || login}/#/counter-order-${
                          admin.socket
                        }`}
                      />
                    </View>
                  </View>
                )}
              </View>
            </View>
            <View style={styles.explain}>
              <Text style={styles.explainText1}>付款流程：</Text>
              <View style={styles.step}>
                <Text style={styles.explainText2}>1</Text>
              </View>
              <Text style={styles.code}>扫描商品条码</Text>
              <View style={styles.step}>
                <Text style={styles.explainText2}>2</Text>
              </View>
              <Text style={styles.explainText1}>
                {isCard ? '刷卡付款' : '微信/支付宝扫二维码或付款码付款'}
              </Text>
            </View>
          </View>
          {width > 801 && !isCard ? (
            <View style={styles.footer}>
              {adType === 'image' ? (
                imgArr && imgArr.length > 0 ? (
                  imgArr.length === 1 ? (
                    imgArr.map((v, index) => (
                      <Image
                        key={index}
                        source={{uri: v}}
                        style={styles.swiperImg}
                      />
                    ))
                  ) : (
                    <Swiper
                      style={styles.swiper} // 样式
                      loop // 如果设置为false，那么滑动到最后一张时，再次滑动将不会滑到第一张图片。
                      autoplay // 自动轮播
                      autoplayTimeout={autoplayTime || 10} // 每隔10秒切换
                      horizontal // 水平方向，为false可设置为竖直方向
                      showsButtons={false} // 为false时不显示控制按钮
                      showsPagination={false} // 为false不显示下方圆点
                    >
                      {imgArr.map((v, index) => (
                        <Image
                          key={index}
                          source={{uri: v}}
                          style={styles.swiperImg}
                        />
                      ))}
                    </Swiper>
                  )
                ) : (
                  <Swiper
                    style={styles.swiper} // 样式
                    loop // 如果设置为false，那么滑动到最后一张时，再次滑动将不会滑到第一张图片。
                    autoplay // 自动轮播
                    autoplayTimeout={autoplayTime || 10} // 每隔10秒切换
                    horizontal // 水平方向，为false可设置为竖直方向
                    showsButtons={false} // 为false时不显示控制按钮
                    showsPagination={false} // 为false不显示下方圆点
                  >
                    <Image
                      source={require('../assets/Vertical/first.jpg')}
                      style={styles.swiperImg}
                    />
                    <Image
                      source={require('../assets/Vertical/second.jpg')}
                      style={styles.swiperImg}
                    />
                    <Image
                      source={require('../assets/Vertical/third.jpg')}
                      style={styles.swiperImg}
                    />
                  </Swiper>
                )
              ) : (
                <Swiper
                  style={styles.swiper} // 样式
                  loop // 如果设置为false，那么滑动到最后一张时，再次滑动将不会滑到第一张图片。
                  autoplay // 自动轮播
                  autoplayTimeout={autoplayTime || 10} // 每隔10秒切换
                  horizontal // 水平方向，为false可设置为竖直方向
                  showsButtons={false} // 为false时不显示控制按钮
                  showsPagination={false} // 为false不显示下方圆点
                >
                  <Image
                    source={require('../assets/Vertical/first.jpg')}
                    style={styles.swiperImg}
                  />
                  <Image
                    source={require('../assets/Vertical/second.jpg')}
                    style={styles.swiperImg}
                  />
                  <Image
                    source={require('../assets/Vertical/third.jpg')}
                    style={styles.swiperImg}
                  />
                </Swiper>
              )}
            </View>
          ) : (
            <View />
          )}
        </View>
        <ModalView visible={goods.cardVisible}>
          <View
            style={{
              width: scaleSize(900),
              height: scaleSize(300),
              backgroundColor: 'white',
              justifyContent: 'center',
              alignItems: 'center',
            }}>
            <Text style={{fontSize: scaleSize(30), color: '#555'}}>
              请刷卡付款
            </Text>
            <Image source={require('../assets/voice.gif')} />
          </View>
        </ModalView>
      </View>
    );
  }
}

class HintPhone extends React.Component {
  render() {
    let {visible, contact, closeHint} = this.props;
    return (
      <Modal visible={visible} transparent>
        <View>
          <Touch
            style={{
              width: '100%',
              height: '100%',
              backgroundColor: 'rgba(0, 0, 0, .5)',
            }}
            onPress={closeHint}>
            <View />
          </Touch>
          <View style={styles.HintPhone}>
            <Image style={{width: '60%', height: '60%'}} source={call} />
            <Text style={{fontSize: scaleSize(30)}}>正在呼叫客服</Text>
            <View style={{display: 'flex', marginTop: 10}}>
              <Text style={{fontSize: scaleSize(20), color: '#7f7f7f'}}>
                如无法接通客服,可拨打电话: {contact}
              </Text>
            </View>
            <Touch onPress={closeHint}>
              <View
                style={{
                  width: scaleSize(200),
                  height: scaleSize(65),
                  borderRadius: 100,
                  backgroundColor: '#fc4000',
                  marginTop: 30,
                  display: 'flex',
                  justifyContent: 'center',
                  alignItems: 'center',
                }}>
                <Text style={{color: '#ffffff', fontSize: scaleSize(30)}}>
                  关闭弹窗
                </Text>
              </View>
            </Touch>
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  HintPhone: {
    width: '50%',
    height: '25%',
    backgroundColor: '#ffffff',
    position: 'absolute',
    top: '20%',
    left: '25%',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    opacity: 40,
  },
  main: {
    backgroundColor: '#F0F0F0',
    height: '100%',
    position: 'relative',
  },
  header: {
    flexDirection: 'row',
    justifyContent: 'space-around',
    alignItems: 'center',
    backgroundColor: '#fc4000',
    height: '6%',
    paddingRight: width > 801 ? 40 : scaleSize(25),
    paddingLeft: width > 801 ? 40 : scaleSize(25),
  },
  left: {
    flexDirection: 'row',
    width: width > 801 ? '60%' : '55%',
  },
  logo: {
    width: width > 801 ? 100 : scaleSize(75),
    height: width > 801 ? 100 : scaleSize(75),
  },
  counterText: {
    marginLeft: width > 801 ? 40 : scaleSize(22),
    marginRight: width > 801 ? 40 : scaleSize(22),
  },
  right: {
    flexDirection: 'row',
  },
  phone: {
    width: width > 801 ? 60 : scaleSize(75),
    height: width > 801 ? 60 : scaleSize(75),
    marginRight: width > 801 ? 10 : scaleSize(20),
    marginLeft: width > 801 ? 20 : scaleSize(15),
  },
  number: {
    fontSize: width > 801 ? 45 : setSpText(60),
    color: '#ffffff',
  },
  container: {
    height: width > 801 ? '62%' : '94%',
  },
  goodsStyle: {
    width: '100%',
    backgroundColor: '#ffffff',
  },
  pagination: {
    flex: 1,
    backgroundColor: '#fff',
    marginTop: '12%',
    flexDirection: 'column',
    alignItems: 'center',
    justifyContent: 'center',
  },
  paginationText: {
    fontSize: width > 801 ? 40 : setSpText(50),
  },
  imgPagination: {
    width: width > 801 ? 50 : scaleSize(75),
    height: width > 801 ? 50 : scaleSize(75),
  },
  btnHighStyle: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: '#fff',
    paddingBottom: 10,
    paddingTop: 10,
    marginBottom: 17.5,
    borderBottomWidth: 1,
    borderBottomColor: '#959595',
    elevation: 3,
    shadowColor: '#F5F5F5',
    shadowOffset: {
      height: 0,
      width: 0,
    },
    shadowOpacity: 0.3,
    shadowRadius: 5,
  },
  btnLowStyle: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: '#fff',
    paddingBottom: 10,
    paddingTop: 10,
    marginBottom: 15,
    borderBottomWidth: 1,
    borderBottomColor: '#959595',
    elevation: 5,
    shadowColor: '#F5F5F5',
    shadowOffset: {
      height: 0,
      width: 0,
    },
    shadowOpacity: 0.3,
    shadowRadius: 5,
  },
  btnText: {
    fontSize: 20,
    color: '#fff',
    paddingTop: 10,
    paddingBottom: 10,
    paddingRight: 20,
    paddingLeft: 20,
  },
  bag: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: '#F0F0F0',
    // paddingBottom: 20,
  },
  bagMore: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'flex-start',
    backgroundColor: '#F0F0F0',
    marginLeft: '5%',
    // paddingBottom: 20,
  },
  btnBag: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: '#4D4D4D',
    padding: 10,
    marginBottom: 10,
    marginLeft: 20,
    marginRight: 20,
    // borderBottomWidth: 1,
    // borderBottomColor: '#959595',
    overflow: 'hidden',
    elevation: 3,
    shadowColor: '#888888',
    shadowOffset: {
      height: 0,
      width: 0,
    },
    shadowOpacity: 0.3,
    shadowRadius: 5,
  },
  btnImage: {
    height: 25,
    width: 25,
    marginLeft: 5,
    marginRight: 5,
  },
  textBag: {
    fontSize: 20,
    color: '#fff',
    marginLeft: 5,
    marginRight: 5,
  },
  shadow: {
    height: 2,
    elevation: 2,
    border: 1,
    borderColor: '#888888',
    marginBottom: 4,
  },
  guide: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: '#24af41',
    // backgroundColor: '#1b7dc7',
  },
  guideText: {
    fontSize: 30,
    color: '#fff',
  },
  down: {
    width: 50,
    height: 70,
  },
  payment: {
    display: 'flex',
    flexDirection: 'row',
    alignContent: 'space-around',
    marginBottom: 10,
  },
  paymentLeft: {
    width: '34%',
    display: 'flex',
    flexDirection: 'row',
    // alignContent: 'space-around',
    borderLeftWidth: 1,
    borderTopWidth: 1,
    borderBottomWidth: 1,
    borderLeftColor: '#959595',
    borderTopColor: '#959595',
    borderBottomColor: '#959595',
    // borderWidth: 1,
    // borderColor: '#959595',
    backgroundColor: '#fff',
    paddingTop: 15,
    paddingBottom: 15,
    // marginRight: 10,
    // overflow: 'hidden',
    elevation: 3,
    shadowColor: '#888888',
    shadowOffset: {
      height: 0,
      width: 0,
    },
    shadowOpacity: 0.3,
    shadowRadius: 5,
  },
  barcode: {
    width: '50%',
    display: 'flex',
    flexDirection: 'column',
    // alignContent: 'center',
    justifyContent: 'center',
    alignItems: 'flex-end',
  },
  leftLine1: {
    width: '80%',
    borderWidth: 1,
    borderColor: '#959595',
    height: 1,
  },
  amount: {
    width: '50%',
    display: 'flex',
    flexDirection: 'column',
    // alignContent: 'center',
    justifyContent: 'center',
    alignItems: 'flex-start',
  },
  total: {
    color: 'red',
    fontSize: width > 801 ? 40 : 35,
  },
  leftLine2: {
    width: '70%',
    borderWidth: 1,
    borderColor: '#959595',
    height: 1,
  },
  leftText1: {
    fontSize: width > 801 ? 40 : 35,
    marginRight: width > 801 ? 30 : 18,
  },
  leftText2: {
    fontSize: width > 801 ? 40 : 35,
  },
  faceScan: {
    width: '32%',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    flexDirection: 'column',
    borderWidth: 1,
    borderColor: '#00BBFF',
    backgroundColor: '#fff',
    elevation: 3,
    // shadowColor: '#888888',
    // shadowOffset: {
    //   height: 0,
    //   width: 0,
    // },
    // shadowOpacity: 0.5,
    // shadowRadius: 5,
  },
  faceGif: {
    width: '100%',
    height: 210,
  },
  facePay: {
    display: 'flex',
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: width > 801 ? 10 : scaleSize(10),
  },
  payImage: {
    width: 30,
    height: 30,
  },
  payText: {
    fontSize: 25,
    marginLeft: 10,
  },
  paymentRight: {
    width: '34%',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    // overflow: 'hidden',
    flexDirection: 'column',
    borderRightWidth: 1,
    borderTopWidth: 1,
    borderBottomWidth: 1,
    borderRightColor: '#959595',
    borderTopColor: '#959595',
    borderBottomColor: '#959595',
    // borderWidth: 1,
    // borderColor: '#959595',
    backgroundColor: '#fff',
    height: 260,
    // marginLeft: 10,
    elevation: 3,
    shadowColor: '#888888',
    shadowOffset: {
      height: 0,
      width: 0,
    },
    shadowOpacity: 0.5,
    shadowRadius: 5,
  },
  paymentRightTitle: {
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  paymentRightContents: {
    display: 'flex',
    flexDirection: 'column',
    marginRight: width > 801 ? 40 : 10,
  },
  paymentRightText: {
    fontSize: width > 801 ? 35 : 30,
  },
  paymentRightImage: {
    width: width > 801 ? 50 : 40,
    height: width > 801 ? 50 : 40,
    marginTop: 5,
    marginBottom: 5,
  },
  paymentRightCode: {
    display: 'flex',
    flexDirection: 'row',
  },
  firstThStyle: {
    width: '30%',
    alignItems: 'flex-start',
    justifyContent: 'center',
    paddingTop: width > 801 ? 18 : scaleHeight(30),
    paddingBottom: width > 801 ? 18 : scaleHeight(30),
    paddingLeft: width > 801 ? 10 : scaleSize(20),
    paddingRight: width > 801 ? 10 : scaleSize(20),
  },
  ThStyle: {
    width: '20%',
    alignItems: 'center',
    justifyContent: 'center',
    paddingTop: width > 801 ? 18 : scaleHeight(30),
    paddingBottom: width > 801 ? 18 : scaleHeight(30),
    paddingLeft: width > 801 ? 10 : scaleSize(20),
    paddingRight: width > 801 ? 10 : scaleSize(20),
  },
  ThStyleMoney: {
    width: '30%',
    alignItems: 'center',
    justifyContent: 'center',
    paddingTop: width > 801 ? 18 : scaleHeight(30),
    paddingBottom: width > 801 ? 18 : scaleHeight(30),
    paddingLeft: width > 801 ? 10 : scaleSize(20),
    paddingRight: width > 801 ? 10 : scaleSize(20),
  },
  ThText: {
    fontSize: setSpText(40),
  },
  oddCell: {
    flexDirection: 'row',
    backgroundColor: '#fff',
  },
  evenCell: {
    flexDirection: 'row',
    backgroundColor: '#F0F0F0',
  },
  firstTdStyle: {
    width: '30%',
    alignItems: 'flex-start',
    justifyContent: 'center',
    paddingTop: width > 801 ? 18 : scaleHeight(30),
    paddingBottom: width > 801 ? 18 : scaleHeight(30),
    paddingLeft: width > 801 ? 10 : scaleSize(20),
    paddingRight: width > 801 ? 10 : scaleSize(20),
  },
  TdStyle: {
    flexDirection: 'row',
    width: '20%',
    alignItems: 'center',
    justifyContent: 'center',
    paddingTop: width > 801 ? 18 : scaleHeight(30),
    paddingBottom: width > 801 ? 18 : scaleHeight(30),
    paddingLeft: width > 801 ? 10 : scaleSize(20),
    paddingRight: width > 801 ? 10 : scaleSize(20),
  },
  TdStyleMoney: {
    flexDirection: 'row',
    width: '30%',
    alignItems: 'center',
    justifyContent: 'center',
    paddingTop: width > 801 ? 18 : scaleHeight(30),
    paddingBottom: width > 801 ? 18 : scaleHeight(30),
    paddingLeft: width > 801 ? 10 : scaleSize(20),
    paddingRight: width > 801 ? 10 : scaleSize(20),
    position: 'relative',
  },
  iconStyle: {
    position: 'absolute',
    right: 20,
  },
  TdText: {
    fontSize: width > 801 ? 25 : setSpText(30),
  },
  explain: {
    display: 'flex',
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: '#fc4000',
    padding: width > 801 ? 20 : 10,
  },
  explainText1: {
    fontSize: width > 801 ? 30 : 25,
    color: '#fff',
    marginRight: 3,
  },
  step: {
    display: 'flex',
    flexDirection: 'row',
    justifyContent: 'center',
    width: width > 801 ? 40 : 35,
    height: width > 801 ? 40 : 35,
    backgroundColor: '#fff',
    borderRadius: 20,
    marginRight: 5,
  },
  explainText2: {
    color: '#fc4000',
    fontSize: width > 801 ? 30 : 25,
  },
  code: {
    fontSize: width > 801 ? 30 : 25,
    color: '#fff',
    marginRight: width > 801 ? 50 : 25,
  },
  footer: {
    height: '32%',
    backgroundColor: '#0f0f0f',
    width: '100%',
  },
  swiper: {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
  },
  swiperImg: {
    justifyContent: 'center',
    alignItems: 'center',
    width: '90%',
    height: '90%',
    marginLeft: '5%',
    marginTop: '2.5%',
    marginRight: '5%',
    marginBottom: '2.5%',
  },
  guardModal: {
    position: 'absolute',
    top: 0,
    left: 0,
    zIndex: 999999999999999,
    elevation: 6,
    display: 'flex',
    width: '100%',
    height: '100%',
    backgroundColor: '#000000',
  },
  guardModal_image: {
    height: '70%',
    width: '100%',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
  },
  Imageee: {
    height: '65%',
    width: '80%',
  },
  guardModal_button: {
    height: '30%',
    width: '100%',
    display: 'flex',
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  guardModal_button_call: {
    backgroundColor: '#fc4000',
    borderRadius: 100,
    color: '#ffffff',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    width: scaleSize(350),
    height: scaleSize(125),
    marginRight: 50,
  },
  guardModal_button_nobuy: {
    borderWidth: 5,
    borderColor: '#ffffff',
    borderRadius: 100,
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    width: scaleSize(350),
    height: scaleSize(125),
  },
  callText: {
    fontSize: scaleSize(45),
    color: '#ffffff',
  },
};

export default CounterMixins(VerticalPage);
