import React, {Component} from 'react';
import {Image, Text, View} from 'react-native';
import {appName} from '../utils/config';
import {setSpText, scaleSize} from '../utils/screen';

class HomeLayout extends Component {
  render() {
    return (
      <View style={styles.container}>
        <View style={styles.title}>
          <Image
            style={styles.titleImg}
            source={require('../assets/logo2.png')}
            resizeMode="contain"
          />
          <Image
            style={{marginLeft: scaleSize(40)}}
            source={require('../assets/Vertical/24h.png')}
          />
          <Text style={styles.titleText}>{appName}</Text>
        </View>
        {this.props.children}
      </View>
    );
  }
}
const styles = {
  title: {
    top: 0,
    paddingLeft: scaleSize(50),
    flexDirection: 'row',
    height: scaleSize(220),
    width: '100%',
    position: 'absolute',
    backgroundColor: 'white',
    alignItems: 'center',
    elevation: 10,
    background: '#f5f5f5',
  },
  titleImg: {
    width: scaleSize(150),
    height: scaleSize(150),
  },
  titleText: {
    color: '#333',
    fontSize: setSpText(60),
    marginLeft: 30,
  },
  container: {
    flex: 1,
    backgroundColor: '#ffffff',
    justifyContent: 'center',
    alignItems: 'center',
  },
};

export default HomeLayout;
