import React, {Component} from 'react';
import {connect} from 'react-redux';
import Touch from '../components/Touch';
import {View, Image, Text, Dimensions, ScrollView} from 'react-native';
import {setSpText} from '../utils/screen';
import SearchGoods from '../components/searchGoods';
import Car from '../components/Car';
import Settles from '../components/Settles';
import {imgUrl} from '../utils/config';

const {width, height} = Dimensions.get('screen');
@connect(({searchGoods}) => ({searchGoods}))
class OrderPage extends Component {
  state = {
    goodsArr: [],
    num: 0,
    carVisible: false,
    searchVisible: false,
    settleVisible: false,
    goodsNumber: {},
    total: 0,
    goodsMap: [],
    pageX: 0,
    pageY: 0,
  };
  ref = '';
  componentDidMount() {
    this.getGoodsList();
    // window.scan = this.submitBarcode;
    // const handleScan = this.submitBarcode;
    // KeyEvent.removeKeyDownListener();
  }

  getGoodsList = async () => {
    let {data} = await this.props.dispatch({
      type: 'searchGoods/getStoreGoods',
      page: 0,
      size: 100,
    });
    if (data.code === 1) {
      await this.setState({
        goodsArr: data.data,
      });
    }
  };

  goodsCar = () => {
    let {carVisible} = this.state;
    this.setState({
      carVisible: !carVisible,
    });
  };

  goodsSub = async v => {
    let {goodsNumber, num, total} = this.state;
    goodsNumber[v.barcode].num -= 1;
    if (goodsNumber[v.barcode].num === 0) {
      delete goodsNumber[v.barcode];
    }
    this.setState({
      goodsNumber,
      num: num - 1,
      total: total - v.prePrice,
    });
    this.total(goodsNumber);
  };

  goodsAdd = async v => {
    let {goodsNumber, num, total} = this.state;
    if (goodsNumber[v.barcode] && goodsNumber[v.barcode].num > 0) {
      goodsNumber[v.barcode].num += 1;
    } else {
      goodsNumber[v.barcode] = {
        num: 1,
        name: v.name,
        prePrice: v.prePrice,
        barcode: v.barcode,
      };
    }
    this.setState({
      goodsNumber,
      num: num + 1,
      total: total + v.prePrice,
    });
    await this.total(goodsNumber);
  };

  total = goodsNumber => {
    let goods = [];
    Object.keys(goodsNumber).map(v => {
      goods.push(goodsNumber[v]);
    });
    this.setState({
      goodsMap: goods,
    });
  };

  emptyCar = async () => {
    await this.setState({
      goodsNumber: {},
      num: 0,
      total: 0,
    });
    this.total(this.state.goodsNumber);
  };
  visible = () => {
    this.setState({
      searchVisible: true,
    });
  };
  clearLister = () => {
    this.setState({
      settleVisible: true,
    });
  };

  render() {
    let {
      goodsArr,
      num,
      carVisible,
      searchVisible,
      settleVisible,
      goodsNumber,
      total,
      goodsMap,
    } = this.state;
    return (
      <View style={styles.body}>
        {/*<View style={styles.dynamic} />*/}
        <Car
          carVisible={carVisible}
          num={num}
          total={total}
          emptyCar={this.emptyCar}
          goodsMap={goodsMap}
          goBack={this.goodsCar}
          goodsSub={this.goodsSub}
          goodsAdd={this.goodsAdd}
        />
        <SearchGoods
          searchVisible={searchVisible}
          goodsNumber={goodsNumber}
          goodsAdd={this.goodsAdd}
          goodsSub={this.goodsSub}
          cancelSearch={() => this.setState({searchVisible: false})}
        />
        <Settles
          settleVisible={settleVisible}
          num={num}
          total={total}
          goodsMap={goodsMap}
          emptyCar={this.emptyCar}
          closeSettle={() => this.setState({settleVisible: false})}
        />
        <Touch style={styles.search} onPress={() => this.visible()}>
          <View style={styles.searchInput}>
            <View style={styles.searchIcon}>
              <Image
                style={styles.img}
                source={require('../assets/Order/search.png')}
              />
            </View>
            <View style={styles.searchText} />
            <Text style={styles.searchBtn}>搜索</Text>
          </View>
        </Touch>
        <View style={styles.info}>
          {/*分类*/}
          {/*<View style={styles.classify} />*/}
          {/*列表*/}
          <ScrollView style={styles.goods}>
            <View style={styles.goodsBox}>
              {goodsArr.length > 0 &&
                goodsArr.map((v, key) => {
                  return (
                    <View style={styles.goodsItem} key={key}>
                      <View style={styles.goodsImg}>
                        <Image
                          style={styles.img}
                          source={{uri: `${imgUrl}${v.image}`}}
                        />
                      </View>
                      <Text style={styles.goodsName}>{v.name}</Text>
                      <Text style={styles.goodsPrice}>￥{v.prePrice}</Text>
                      <View style={styles.goodsNum}>
                        <Touch
                          style={
                            goodsNumber[v.barcode] &&
                            goodsNumber[v.barcode].num > 0
                              ? styles.goodsSub
                              : styles.display
                          }
                          onPress={() => {
                            this.goodsSub(v);
                          }}>
                          <Image
                            style={styles.img}
                            source={require('../assets/Order/subtract.png')}
                          />
                        </Touch>
                        <Text
                          style={
                            goodsNumber[v.barcode] &&
                            goodsNumber[v.barcode].num > 0
                              ? styles.goodsNums
                              : styles.display
                          }>
                          {goodsNumber[v.barcode]
                            ? goodsNumber[v.barcode].num
                            : ''}
                        </Text>
                        <Touch
                          style={styles.goodsAdd}
                          // ref={ref => (v.ref = ref)}
                          onPress={() => {
                            this.goodsAdd(v);
                          }}>
                          <Image
                            style={styles.img}
                            source={require('../assets/Order/add.png')}
                          />
                        </Touch>
                      </View>
                    </View>
                  );
                })}
            </View>
          </ScrollView>
        </View>
        <View style={styles.settle}>
          <View style={styles.car}>
            <Touch
              style={num > 0 ? styles.carImgs : styles.carImg}
              onPress={this.goodsCar}>
              <View>
                <View style={[num > 0 ? styles.carNum : styles.display]}>
                  <Text style={{color: '#fff'}}>{num}</Text>
                </View>
                <Image
                  style={styles.img}
                  source={require('../assets/Order/car.png')}
                />
              </View>
            </Touch>
          </View>
          <View style={styles.total}>
            {num > 0 ? (
              <Text style={{marginLeft: 30, fontSize: setSpText(50)}}>
                总计:
                <Text style={{fontSize: setSpText(40), color: '#e21918'}}>
                  ￥{parseInt(total)}
                  <Text style={{fontSize: setSpText(25)}}>
                    .
                    {parseInt((total - parseInt(total)).toFixed(2) * 100) ||
                      '00'}
                  </Text>
                </Text>
              </Text>
            ) : (
              <Text style={{marginLeft: 30, fontSize: setSpText(50)}}>
                暂无商品
              </Text>
            )}
          </View>
          <View style={num > 0 ? styles.onSubmit : styles.noSubmit}>
            <Text
              style={{color: '#fff', fontSize: setSpText(50)}}
              onPress={() => num > 0 && this.clearLister()}>
              结算
            </Text>
          </View>
        </View>
      </View>
    );
  }
}

const styles = {
  body: {
    width,
    height,
    backgroundColor: '#fff',
  },
  hidden: {
    display: 'none',
  },
  dynamic: {
    width: 20,
    height: 20,
    borderRadius: 20,
    backgroundColor: 'red',
    zIndex: 9,
    position: 'absolute',
  },

  search: {
    width,
    height: height * 0.07,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  searchInput: {
    width: width * 0.9,
    height: height * 0.07 * 0.85,
    borderWidth: 1,
    borderColor: '#ccc',
    borderRadius: height * 0.07 * 0.85,
    flexDirection: 'row',
    alignItems: 'center',
  },
  input: {
    width: '100%',
    height: '100%',
    fontSize: setSpText(50),
  },
  searchIcon: {
    width: width * 0.08,
    height: width * 0.08,
    marginLeft: 20,
  },
  searchText: {
    width: width * 0.63,
    height: height * 0.07 * 0.85,
  },
  searchBtn: {
    width: width * 0.15,
    height: height * 0.07 * 0.7,
    borderRadius: height * 0.07 * 0.7,
    fontSize: setSpText(50),
    color: '#fff',
    backgroundColor: '#fc4000',
    textAlign: 'center',
    lineHeight: height * 0.07 * 0.7,
  },
  info: {
    width,
    height: height * 0.86,
    borderTopWidth: 1,
    borderTopColor: '#ccc',
  },
  classify: {
    width: width,
    height: height * 0.06,
    backgroundColor: '#ccc',
  },
  goods: {
    width: width,
    height: height * 0.8,
  },
  goodsBox: {
    width: width,
    flexDirection: 'row',
    flexWrap: 'wrap',
    backgroundColor: '#f3f4f5',
  },
  goodsItem: {
    width: width * 0.3,
    height: height * 0.8 * 0.3,
    marginTop: 20,
    marginLeft: width * 0.025,
    alignItems: 'center',
    backgroundColor: '#fff',
    borderRadius: 20,
  },
  goodsImg: {
    width: width * 0.85 * 0.3333 * 0.95,
    height: width * 0.85 * 0.3333 * 0.8,
    marginTop: 10,
  },
  goodsName: {
    width: width * 0.85 * 0.3333 * 0.95,
    height: 40,
    lineHeight: 50,
    fontSize: setSpText(30),
  },
  goodsPrice: {
    width: width * 0.85 * 0.3333 * 0.9,
    height: 25,
    // textAlign: 'right',
    paddingRight: 20,
    marginTop: 5,
    marginBottom: 5,
    color: '#e21918',
    fontSize: setSpText(20),
  },
  goodsNum: {
    width: width * 0.85 * 0.3333 * 0.9,
    height: 40,
    position: 'relative',
  },
  goodsSub: {
    width: 40,
    height: 40,
    borderRadius: 40,
    backgroundColor: '#fc4000',
  },
  img: {
    width: '100%',
    height: '100%',
  },
  goodsNums: {
    width: width * 0.85 * 0.3333 * 0.9 - 100,
    height: 40,
    textAlign: 'center',
    fontSize: 40,
    position: 'absolute',
    left: 50,
  },
  goodsAdd: {
    width: 40,
    height: 40,
    borderRadius: 40,
    backgroundColor: '#fc4000',
    position: 'absolute',
    right: 0,
  },
  settle: {
    width,
    height: height * 0.07,
    flexDirection: 'row',
    alignItems: 'center',
    backgroundColor: '#F3F4F5',
  },
  car: {
    width: width * 0.15,
    height: height * 0.06,
    position: 'relative',
  },
  display: {
    display: 'none',
  },
  carNum: {
    width: 20,
    height: 20,
    position: 'absolute',
    top: 5,
    right: -8,
    borderRadius: 25,
    backgroundColor: 'red',
    color: '#fff',
    zIndex: 2,
    justifyContent: 'center',
    alignItems: 'center',
  },
  carImg: {
    width: height * 0.06,
    height: height * 0.06,
    marginLeft: 20,
    backgroundColor: '#ccc',
  },
  carImgs: {
    width: height * 0.06,
    height: height * 0.06,
    marginLeft: 20,
    backgroundColor: '#fc4000',
  },
  total: {
    width: width * 0.6,
    height: height * 0.07,
    justifyContent: 'center',
    backgroundColor: '#F3F4F5',
  },
  onSubmit: {
    width: width * 0.23,
    height: height * 0.06,
    borderRadius: height * 0.07,
    backgroundColor: '#fc4000',
    justifyContent: 'center',
    alignItems: 'center',
  },
  noSubmit: {
    width: width * 0.23,
    height: height * 0.06,
    borderRadius: height * 0.07,
    backgroundColor: '#ccc',
    justifyContent: 'center',
    alignItems: 'center',
  },
};

export default OrderPage;
