import React, {Component} from 'react';
import {Modal, View, Text, Image} from 'react-native';
import Touch from './Touch';
import ModalStyles from './Modal/styles';
import {font} from '../utils/common';
import NP from '../utils/np';

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
    // width: 380,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

class RedPacketModal extends Component {
  receive = async () => {
    let {onCloseLucky, onReceiveLucky} = this.props;
    onReceiveLucky();
    onCloseLucky();
  };

  closeLucky = () => {
    let {onCloseLucky} = this.props;
    onCloseLucky();
  };

  render() {
    // 红包弹窗
    const {luckyVisible, amount} = this.props;
    return (
      <Modal visible={luckyVisible} maskClosable transparent styles={mStyles}>
        <View style={styles.modalBackgroundStyle}>
          <View style={styles.modal}>
            <View style={styles.background}>
              <Image
                source={require('../assets/Vertical/red.png')}
                style={styles.img}
              />
            </View>
            <View style={styles.content}>
              <View style={styles.top}>
                <Text style={styles.topText}>恭喜您获得</Text>
                <Text style={styles.topAmountText}>
                  {NP.round(amount || 0, 2).toFixed(2)}元
                </Text>
              </View>
              <Touch onPress={this.receive} style={styles.bottom}>
                <View style={styles.btnReceive}>
                  <Text style={styles.receviceText}>立即领取</Text>
                </View>
              </Touch>
            </View>
            <Touch onPress={this.closeLucky} style={styles.close}>
              <Image
                source={require('../assets/Vertical/close.png')}
                style={styles.btnClose}
              />
            </Touch>
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  modalBackgroundStyle: {
    flex: 1,
    // backgroundColor: 'rgba(0, 0, 0, 0.5)',
    backgroundColor: 'rgba(3, 3, 3, .2)',
  },
  modal: {
    height: '60%',
    width: '80%',
    marginLeft: '10%',
    marginTop: '30%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  background: {
    width: '100%',
    height: '100%',
  },
  img: {
    width: '100%',
    height: '100%',
  },
  content: {
    width: '100%',
    height: '100%',
    position: 'absolute',
    top: '45%',
    left: 0,
  },
  top: {
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  topText: {
    color: '#ffffff',
    fontSize: 40,
  },
  topAmountText: {
    color: '#ffffff',
    fontSize: 80,
    lineHeight: 100,
    paddingTop: 20,
    paddingBottom: 20,
  },
  bottom: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  btnReceive: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    width: 400,
    height: 100,
    backgroundColor: '#FFD101',
    borderRadius: 100,
  },
  receviceText: {
    fontSize: 45,
    color: '#ffffff',
  },
  close: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    paddingTop: 30,
  },
  btnClose: {
    width: 60,
    height: 60,
  },
};

export default RedPacketModal;
