import {NativeModules} from 'react-native';

const timeout = ms =>
  new Promise(resolve => {
    setTimeout(() => resolve(false), ms);
  });

const init = new Promise(resolve => {
  NativeModules.WxFacepay.init().then(resolve);
});

NativeModules.WxFacepay.initialize = ms => {
  return Promise.race([init, timeout(ms)]);
};

// delete NativeModules.WxFacepay.getUserPayScoreStatus; // 测试刷脸支付分兼容问题

export default NativeModules.WxFacepay;
