import React from 'react';
import {View, Text, DeviceEventEmitter} from 'react-native';
import {height, width} from '../../utils/screen';
import Scales from '../../utils/Scales';
import Touch from '../../components/Touch';

export default class ScalesPage extends React.Component {
  state = {
    data: '',
    weight: '',
  };

  async componentDidMount() {
    DeviceEventEmitter.addListener('onScalesChange', ({weight}) => {
      this.setState({weight});
    });
  }

  read = async () => {
    const data = await Scales.read(0);
    this.setState({data});
  };

  render() {
    const style = {fontSize: 50, padding: 10};
    const {data, weight} = this.state;
    return (
      <View
        style={{
          width,
          height,
          backgroundColor: 'rgba(255,255,255,.5)',
          justifyContent: 'center',
          alignItems: 'center',
        }}>
        <Touch onPress={this.read}>
          <Text style={style}>{data || 'Read'}</Text>
        </Touch>
        <Text style={style}>{weight}</Text>
      </View>
    );
  }
}
