import React from 'react';
import {View, Text} from 'react-native';
import Icon from 'react-native-vector-icons/Ionicons';
import Touch from '../components/Touch';
import {colors} from '../utils/common';
import NP from '../utils/np';

const itemFontsize = 18;

export default class GoodsItem extends React.Component {
  render() {
    let {item, index, numRemove, numAdd, numChange, removeIndex} = this.props;
    return (
      <View
        style={{flexDirection: 'row', alignItems: 'center', height: 55}}
        key={index}>
        <Text
          style={{
            width: 38,
            fontSize: itemFontsize,
            color: colors.textXSActive,
            paddingLeft: 8,
          }}>
          {index + 1}
        </Text>
        <View
          style={{
            flex: 1,
            flexDirection: 'row',
            alignItems: 'center',
          }}>
          <Text
            numberOfLines={1}
            style={{
              flex: 0.4,
              fontSize: itemFontsize,
              color: item.weight ? colors.textXSActive : '#FC4000',
            }}>
            {item.spec ? `${item.name}(${item.spec})` : item.name}
          </Text>
          {item.price ? (
            <View
              style={{
                flex: 0.25,
                justifyContent: 'flex-end',
                alignItems: 'flex-end',
                flexDirection: 'row',
              }}>
              <Text
                style={{
                  fontSize: itemFontsize - 2,
                  textDecorationLine: 'line-through',
                }}>
                ￥{NP.round(item.prePrice, 2).toFixed(2)}/
                <Text
                  style={{
                    fontSize: itemFontsize - 2,
                  }}>
                  {item.unit}
                </Text>
              </Text>
              <Text
                style={{fontSize: itemFontsize, color: colors.textXSActive}}>
                ￥{NP.round(item.price, 2).toFixed(2)}/
                <Text
                  style={{
                    fontSize: itemFontsize,
                  }}>
                  {item.unit}
                </Text>
              </Text>
            </View>
          ) : (
            <Text
              style={{
                flex: 0.25,
                fontSize: itemFontsize,
                textAlign: 'right',
                color: colors.textXSActive,
              }}>
              ￥{NP.round(item.prePrice, 2).toFixed(2)}/{item.unit}
            </Text>
          )}
          <View
            style={{
              flex: 0.2,
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'flex-end',
            }}>
            {item.numChange ? (
              <Touch
                style={{
                  height: 50,
                  justifyContent: 'center',
                  alignItems: 'center',
                }}
                onPress={() => numRemove(item.num, index)}>
                <Icon
                  name="ios-remove-circle"
                  color={item.num === 1 ? '#909090' : '#00c670'}
                  size={30}
                />
              </Touch>
            ) : (
              <View style={{height: 50, width: 25}} />
            )}
            <Touch
              style={{
                width: 40,
                height: 50,
                justifyContent: 'center',
                alignItems: 'center',
              }}
              onPress={() => item.numChange && numChange(index)}>
              <Text
                style={{
                  fontSize: itemFontsize,
                  minWidth: 30,
                  textAlign: 'center',
                  color: colors.textXSActive,
                }}>
                {item.num}
              </Text>
            </Touch>
            {item.numChange ? (
              <Touch
                style={{
                  height: 50,
                  justifyContent: 'center',
                  alignItems: 'center',
                }}
                onPress={() => numAdd(item.num, index)}>
                <Icon name="ios-add-circle" color="#00c670" size={30} />
              </Touch>
            ) : (
              <View style={{height: 50, width: 25}} />
            )}
          </View>
          {item.price ? (
            <Text
              style={{
                fontSize: itemFontsize,
                flex: 0.15,
                textAlign: 'right',
                color: colors.textXSActive,
              }}>
              {NP.round(item.price * item.num, 2).toFixed(2)}
            </Text>
          ) : (
            <Text
              style={{
                fontSize: itemFontsize,
                flex: 0.15,
                textAlign: 'right',
                color: colors.textXSActive,
              }}>
              {NP.round(item.prePrice * item.num, 2).toFixed(2)}
            </Text>
          )}
        </View>
        <Touch
          onPress={() => removeIndex(index)}
          style={{width: 50, alignItems: 'center'}}>
          <View
            style={{
              height: 60,
              width: 40,
              justifyContent: 'center',
              alignItems: 'center',
            }}>
            <Icon name="ios-close-circle" size={28} color={colors.bg} />
          </View>
        </Touch>
      </View>
    );
  }
}
