import React from 'react';
import Modal from 'antd-mobile-rn/lib/modal/Modal.native';
import modalStyle from 'antd-mobile-rn/lib/modal/style/index.native';
import styles from './styles';

const operationStyles = {
  ...styles,
  innerContainer: {
    ...styles.innerContainer,
    width: 600,
  },
  buttonText: {
    ...styles.buttonText,
    alignSelf: 'center',
    fontSize: 35,
  },
};

export type OperationButtonType = {
  text: string,
  onPress?: () => void,
  style?: any,
};

export interface OperationContainerProps {
  actions: Array<OperationButtonType>;
  onAnimationEnd?: (visible: boolean) => void;
}

export default class OperationContainer extends React.Component<
  OperationContainerProps,
  any,
> {
  constructor(props) {
    super(props);
    this.state = {
      visible: true,
    };
  }

  onClose = () => {
    this.setState({
      visible: false,
    });
  };

  render() {
    const {actions, onAnimationEnd} = this.props;
    const footer = actions.map(button => {
      const orginPress = button.onPress || function() {};
      button.onPress = () => {
        const res = orginPress();
        if (res && res.then) {
          res.then(() => {
            this.onClose();
          });
        } else {
          this.onClose();
        }
      };
      return button;
    });
    return (
      <Modal
        operation
        transparent
        maskClosable
        styles={operationStyles}
        visible={this.state.visible}
        onClose={this.onClose}
        onAnimationEnd={onAnimationEnd}
        style={modalStyle.operationContainer}
        bodyStyle={modalStyle.operationBody}
        footer={footer}
      />
    );
  }
}
