import React, {Component} from 'react';
import {Modal, View, Text, Image, FlatList, Dimensions} from 'react-native';
import Icon from 'react-native-vector-icons/Ionicons';
import RtcEngine from 'react-native-agora';
// import {BoxShadow} from 'react-native-shadow';
import AsyncStorage from '@react-native-community/async-storage';
import ModalStyles from './Modal/styles';
import {font} from '../utils/common';
import Touch from './Touch';
import NP from '../utils/np';
import config from '../utils/config';
import phone from '../assets/Vertical/phone.png';

const screenWidth = Dimensions.get('window').width;

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

class OrderDetailsModal extends Component {
  state = {
    conatct: '',
    storeName: '',
  };
  async componentWillMount() {
    let contact = await AsyncStorage.getItem('CONTACT');
    let storeName = await AsyncStorage.getItem('NAME');
    this.setState({
      contact,
      storeName,
    });
  }

  // 生成不重复的key
  keyExtractor = (item: any, index: number) => {
    return String(index);
  };

  onCall = async () => {
    const key = await AsyncStorage.getItem('KEY');
    const channelName = 'face_' + key;
    console.warn(channelName);
    // const engine = await RtcEngine.create(appid);
    // engine.joinChannel(token, channelName, null, 0);
    // engine.joinChannel(token, 'face_001000010105', null, 0);
  };

  // 显示数据
  renderCell = (item, index) => (
    <View style={styles.cell}>
      <View style={styles.TdStyle}>
        {item.url ? (
          <Image source={{uri: item.url}} style={styles.tdImg} />
        ) : (
          ''
        )}
      </View>
      <View style={styles.nameTdStyle}>
        <Text style={styles.TdText} numberOfLines={1}>
          {item.name}
        </Text>
      </View>
      <View style={styles.TdStyle}>
        <Text style={styles.TdText}>x{NP.round(item.num, 0).toFixed(0)}</Text>
      </View>
      <View style={styles.TdStyle}>
        {item.price ? (
          <Text style={styles.TdText}>
            {NP.round(item.price * item.num, 2).toFixed(2)}
          </Text>
        ) : (
          <Text style={styles.TdText}>
            {NP.round(item.prePrice * item.num, 2).toFixed(2)}
          </Text>
        )}
      </View>
    </View>
  );

  render() {
    const {onClose, goodsArr, ...props} = this.props;
    const {contact, storeName} = this.state;
    const len = Math.ceil(screenWidth / 4);
    const arr = [];
    for (let i = 0; i < len / 3; i++) {
      arr.push(i);
    }
    let totalCount = 0;
    let totalPrice = 0;
    goodsArr.map(v => {
      v.url = config.imgUrl + v.barcode + config.watermark;
      if (v.price) {
        totalPrice += v.price * v.num;
        totalCount += (v.prePrice - v.price) * v.num;
      } else {
        totalPrice += v.prePrice * v.num;
      }
    });
    // const shadowWidth = screenWidth * 0.8;
    // const shadowOpt = {
    //   // width: 640, //包裹的子内容多宽这里必须多宽
    //   width: shadowWidth, //包裹的子内容多宽这里必须多宽
    //   height: 80, //同上
    //   // color: '#00CD66', //阴影颜色
    //   // color: '#90EE90',
    //   color: '#B4EEB4',
    //   border: 4, //阴影宽度
    //   radius: 8, //包裹的子元素圆角多少这里必须是多少
    //   opacity: 0.4, //透明度
    //   x: 0,
    //   y: 7,
    //   style: {marginVertical: 5},
    // };
    return (
      <Modal styles={mStyles} {...props}>
        <View style={styles.modal}>
          <View style={styles.header}>
            <View style={styles.title}>
              <View style={styles.left}>
                <Image
                  source={require('../assets/logo2.png')}
                  style={styles.img}
                />
                <Text style={styles.text}>订单详情</Text>
              </View>
              <View style={styles.right}>
                <Touch onPress={() => onClose()}>
                  <Icon name="md-close" color={'#FFFFFF'} size={50} />
                </Touch>
                <Text style={styles.number}>{contact}</Text>
                <Image style={styles.phone} source={phone} />
              </View>
            </View>
            <View style={styles.rod}>
              <View style={styles.rodGradient} />
            </View>
            <View style={styles.storeName}>
              <Text style={styles.storeText}>{storeName}</Text>
            </View>
          </View>
          {goodsArr && goodsArr.length > 0 ? (
            <View style={styles.container}>
              <View style={styles.dottedTop} />
              <View style={styles.dashLine}>
                {arr.map((item, index) => (
                  <Text style={styles.dashItem} key={'dash' + index}>
                    -
                  </Text>
                ))}
              </View>
              <View style={styles.goods}>
                <FlatList
                  style={styles.goodsStyle}
                  keyExtractor={this.keyExtractor}
                  horizontal={false}
                  data={goodsArr}
                  renderItem={({item, index}) => this.renderCell(item, index)}
                />
              </View>
              <View style={styles.dashLine}>
                {arr.map((item, index) => (
                  <Text style={styles.dashItem} key={'dash' + index}>
                    -
                  </Text>
                ))}
              </View>
              <View style={styles.amount}>
                <View style={styles.total}>
                  <Text style={styles.totalText}>商品总额</Text>
                  <Text style={styles.totalText}>
                    ￥{' '}
                    {NP.round(
                      Number(totalPrice) + Number(totalCount),
                      2,
                    ).toFixed(2)}
                  </Text>
                </View>
                <View style={styles.total}>
                  <Text style={styles.totalText}>优惠金额</Text>
                  <Text style={styles.discount}>
                    -￥ {NP.round(totalCount, 2).toFixed(2)}
                  </Text>
                </View>
                <View style={styles.total}>
                  <Text style={styles.totalText}>实付金额</Text>
                  <Text style={styles.totalText}>
                    ￥ {NP.round(totalPrice, 2).toFixed(2)}
                  </Text>
                </View>
              </View>
            </View>
          ) : (
            <View style={styles.container}>
              <View style={styles.dottedTop} />
              <View style={styles.dashLine}>
                {arr.map((item, index) => (
                  <Text style={styles.dashItem} key={'dash' + index}>
                    -
                  </Text>
                ))}
              </View>
              <View style={styles.emptyContainer}>
                <View style={styles.empty}>
                  <Image
                    source={require('../assets/empty.png')}
                    style={styles.emptyImg}
                  />
                </View>
                <View style={styles.empty}>
                  <Text style={styles.tips}>
                    您没有商品记录哦，请将商品拿给买单的人
                  </Text>
                </View>
              </View>
            </View>
          )}
          <View style={styles.footer}>
            {/*<BoxShadow setting={shadowOpt}>*/}
            <View style={styles.service}>
              <Touch onPress={() => this.onCall()} feddback={false}>
                <View style={styles.call}>
                  <Icon name="md-call" color={'#fff'} size={45} />
                  <Text style={styles.callText}>呼叫客服</Text>
                </View>
              </Touch>
            </View>
            {/*</BoxShadow>*/}
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  modal: {
    height: '100%',
    width: '100%',
    // marginLeft: '5%',
    // marginTop: '6%',
    // borderRadius: 20,
    backgroundColor: '#cccccc',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  header: {
    flex: 0.2,
    backgroundColor: '#00CD66',
    width: '100%',
    flexDirection: 'column',
    borderTopRightRadius: 10,
    borderTopLeftRadius: 10,
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: 30,
    marginRight: 30,
    marginTop: 10,
    marginBottom: 10,
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
  },
  img: {
    width: 60,
    height: 60,
    marginRight: 10,
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: 30,
  },
  rod: {
    marginLeft: '3%',
    marginRight: '3%',
    marginTop: '2%',
    borderRadius: 20,
    backgroundColor: '#04BE02',
    height: '12%',
  },
  rodGradient: {
    marginLeft: '3.1%',
    marginRight: '3.1%',
    marginTop: '2%',
    height: '50%',
    // backgroundColor: '#F0FFF0',
    // backgroundColor: '#C1FFC1',
    backgroundColor: '#E0EEE0',
  },
  dashLine: {
    flexDirection: 'row',
    marginLeft: '6%',
    marginRight: '6%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#fff',
  },
  dashItem: {
    height: 3,
    width: 5,
    marginRight: 5,
    backgroundColor: '#ddd',
    fontSize: 20,
  },
  storeName: {
    marginLeft: '6%',
    marginRight: '6%',
    backgroundColor: '#FFF',
    flex: 1,
    flexDirection: 'row',
    alignItems: 'flex-end',
  },
  storeText: {
    fontSize: 40,
    paddingLeft: 40,
    paddingBottom: 10,
  },
  container: {
    flex: 0.7,
    backgroundColor: '#F5F5F5',
    width: '100%',
    flexDirection: 'column',
  },
  dottedTop: {
    height: '3%',
    marginLeft: '6%',
    marginRight: '6%',
    backgroundColor: '#FFF',
  },
  emptyContainer: {
    flex: 1,
    marginLeft: '6%',
    marginRight: '6%',
    backgroundColor: '#fff',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  empty: {
    flexDirection: 'row',
    margin: 10,
  },
  emptyImg: {
    width: 400,
    height: 400,
    resizeMode: 'contain',
  },
  tips: {
    fontSize: 30,
    color: '#8B8989',
  },
  goods: {
    flex: 1,
    marginLeft: '6%',
    marginRight: '6%',
    backgroundColor: '#FFF',
  },
  goodsStyle: {
    width: '100%',
    backgroundColor: '#fff',
  },
  cell: {
    flexDirection: 'row',
  },
  nameTdStyle: {
    width: '40%',
    justifyContent: 'center',
    alignItems: 'flex-start',
    paddingTop: 20,
    paddingBottom: 20,
    paddingLeft: 10,
    paddingRight: 10,
  },
  TdStyle: {
    flexDirection: 'row',
    width: '20%',
    alignItems: 'center',
    justifyContent: 'center',
    paddingTop: 20,
    paddingBottom: 20,
    paddingLeft: 10,
    paddingRight: 10,
  },
  tdImg: {
    width: 60,
    height: 60,
    // marginRight: 10,
    resizeMode: 'contain',
  },
  TdText: {
    fontSize: 25,
  },
  amount: {
    flexDirection: 'column',
    height: '25%',
    backgroundColor: '#FFF',
    marginLeft: '6%',
    marginRight: '6%',
  },
  total: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginLeft: 30,
    marginRight: 30,
    marginTop: 15,
  },
  totalText: {
    fontSize: 30,
  },
  discount: {
    fontSize: 30,
    color: 'red',
  },
  footer: {
    flex: 0.3,
    width: '100%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#F5F5F5',
    borderBottomLeftRadius: 10,
    borderBottomRightRadius: 10,
  },
  phone: {
    width: 40,
    height: 40,
    marginRight: 10,
    resizeMode: 'contain',
  },
  number: {
    color: '#FFFFFF',
    fontSize: 30,
    marginRight: 30,
  },
  service: {
    // width: '98%',
    width: '89%',
    marginLeft: '1%',
    marginRight: '1%',
  },
  call: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    marginBottom: 10,
    padding: 15,
    backgroundColor: '#00CD66',
    borderRadius: 8,
  },
  callText: {
    fontSize: 35,
    color: '#fff',
    marginLeft: 20,
  },
};

export default OrderDetailsModal;
