import React from 'react';
import {View, Text, Image} from 'react-native';
import Icon from 'react-native-vector-icons/Ionicons';
import QRCode from 'react-native-qrcode-svg';
import CounterMixins from './CounterMixins';
import Layout from '../components/Layout';
import Touch from '../components/Touch';
import {width} from '../utils/screen';
import GoodsItem from '../components/GoodsItem';
import {colors, font} from '../utils/common';
import {login} from '../utils/config';
import NP from '../utils/np';

const pageSize = 8; // 分页大小
window.pageSize = pageSize;

class HomePage extends React.Component {
  getGoodsArr = goodsArr => {
    let {current} = this.props;
    let gaTemp = goodsArr.slice((current - 1) * pageSize, current * pageSize);
    return gaTemp.map((item, index) => (
      <GoodsItem
        key={index}
        item={item}
        index={index + (current - 1) * pageSize}
        numRemove={this.props.numRemove}
        numAdd={this.props.numAdd}
        removeIndex={this.props.removeIndex}
        numChange={this.props.numChange}
      />
    ));
  };

  getPagination = goodsArr => {
    let {current} = this.props;
    let goodsLength = Math.ceil(parseFloat(goodsArr.length / pageSize));
    return (
      <View style={styles.pagination}>
        <Touch onPress={() => this.props.dropUp()} feddback={false}>
          <Icon
            name="ios-arrow-dropup-outline"
            color={current > 1 ? '#EA460F' : '#DEDEDE'}
            size={36}
          />
        </Touch>
        <Text style={{fontSize: font.textS, marginVertical: 10}}>
          {current}/{goodsLength}
        </Text>
        <Touch
          onPress={() => this.props.dropDown(goodsLength)}
          feddback={false}>
          <Icon
            name="ios-arrow-dropdown"
            color={current < goodsLength ? '#EA460F' : '#DEDEDE'}
            size={36}
          />
        </Touch>
      </View>
    );
  };

  render() {
    let {admin, goods, goodsArr, qrHost} = this.props;
    let total = 0; // 总数量
    let totalPrice = 0; // 总价
    let totalCount = 0; // 总优惠
    this.totalWeight = 0; // 商品重量
    goodsArr.map(item => {
      total += item.num;
      this.totalWeight += item.weight * item.num;
      if (item.price) {
        totalPrice += item.price * item.num;
        totalCount += (item.prePrice - item.price) * item.num;
      } else {
        totalPrice += item.prePrice * item.num;
      }
    });
    this.totalNum = total;
    this.totalPrice = totalPrice;
    this.totalCount = totalCount;
    return (
      <Layout>
        <View style={styles.cont}>
          <View style={styles.contLeft}>
            <View
              style={{
                flex: 1,
                flexDirection: 'row',
                backgroundColor: '#ffffff',
                borderTopLeftRadius: 3,
                borderTopRightRadius: 3,
                overflow: 'hidden',
              }}>
              <View style={{flex: 1}}>
                <View style={styles.clTop}>
                  <View style={{width: 38}} />
                  <View style={{flex: 1, flexDirection: 'row'}}>
                    <Text
                      style={{...styles.cltText, flex: 0.4, textAlign: 'left'}}>
                      商品名称
                    </Text>
                    <Text
                      style={{
                        ...styles.cltText,
                        flex: 0.25,
                        textAlign: 'right',
                      }}>
                      单价:
                    </Text>
                    <Text
                      style={{
                        ...styles.cltText,
                        flex: 0.2,
                        textAlign: 'right',
                      }}>
                      数量
                    </Text>
                    <Text
                      style={{
                        ...styles.cltText,
                        flex: 0.15,
                        textAlign: 'right',
                      }}>
                      金额
                    </Text>
                  </View>
                  <View style={{width: 50, backgroundColor: '#cccccc'}} />
                </View>
                <View style={styles.cltScroll}>
                  {this.getGoodsArr(goodsArr)}
                </View>
              </View>
              <View style={{width: 70}}>{this.getPagination(goodsArr)}</View>
            </View>
            <View
              style={{
                height: 60,
                flexDirection: 'row',
                justifyContent: 'center',
                alignItems: 'center',
                backgroundColor: '#ffffff',
                borderBottomLeftRadius: 3,
                borderBottomRightRadius: 3,
              }}>
              {goods.bags.map((v, k) => {
                return (
                  <Touch
                    key={k}
                    onPress={() => this.props.pushBag(k)}
                    style={[
                      styles.bagButton,
                      {marginLeft: k === 0 ? 0 : 20, paddingHorizontal: 20},
                    ]}>
                    <Text style={{color: '#ffffff', fontSize: 18}}>
                      点击购买{v.name} ￥{v.price}
                    </Text>
                  </Touch>
                );
              })}
            </View>
            <View
              style={{
                height: 70,
                backgroundColor: '#ffffff',
                marginTop: 10,
                borderRadius: 3,
                flexDirection: 'row',
                alignItems: 'center',
                justifyContent: 'center',
              }}>
              <View
                style={{
                  borderLeftWidth: 1,
                  borderLeftColor: '#cccccc',
                  flex: 1,
                  flexDirection: 'row',
                  justifyContent: 'center',
                }}>
                <View style={styles.infoView}>
                  <Text style={styles.infoText}>合计：</Text>
                  <Text style={styles.infoText}>
                    {NP.round(
                      Number(totalPrice) + Number(totalCount),
                      2,
                    ).toFixed(2)}
                  </Text>
                </View>
                <View style={styles.infoView}>
                  <Text style={styles.infoText}>数量：</Text>
                  <Text style={styles.infoText}>{total}</Text>
                </View>
                <View style={styles.infoView}>
                  <Text style={styles.infoText}>优惠：</Text>
                  <Text style={styles.infoText}>
                    -{NP.round(totalCount, 2).toFixed(2)}
                  </Text>
                </View>
                <View style={styles.infoView}>
                  <Text style={styles.infoText}>金额：</Text>
                  <Text style={styles.infoText}>
                    {NP.round(totalPrice, 2).toFixed(2)}
                  </Text>
                </View>
              </View>
            </View>
            <View style={{height: 50, backgroundColor: '#333'}} />
          </View>
          <View style={styles.contRight}>
            <View
              style={{
                backgroundColor: '#ffffff',
                padding: 10,
                borderRadius: 3,
                flex: 1,
              }}>
              <View
                style={{
                  backgroundColor: '#00be34',
                  paddingTop: 15,
                  paddingBottom: 20,
                  justifyContent: 'center',
                  alignItems: 'center',
                }}>
                <Image
                  style={{height: 22, resizeMode: 'contain', marginBottom: 12}}
                  source={require('../assets/payment_scan.png')}
                />
                <View style={{padding: 15, backgroundColor: 'white'}}>
                  <QRCode
                    logoSize={40}
                    logoBackgroundColor="#fc4000"
                    logo={require('../assets/logo.png')}
                    size={200}
                    value={`${qrHost || login}/#/counter-order-${admin.socket}`}
                  />
                </View>
              </View>
              <View
                style={{
                  flex: 1,
                  backgroundColor: '#FC4000',
                  marginTop: 10,
                  alignItems: 'center',
                }}>
                <Image
                  style={{
                    height: 22,
                    resizeMode: 'contain',
                    marginBottom: 12,
                    marginTop: 10,
                  }}
                  source={require('../assets/payment_code_text.png')}
                />
                <Image
                  style={{flex: 1}}
                  source={require('../assets/payment_code.gif')}
                />
              </View>
            </View>
            <View
              style={{
                height: 70,
                backgroundColor: '#ffffff',
                marginTop: 10,
                borderRadius: 3,
                flexDirection: 'row',
                alignItems: 'center',
                paddingHorizontal: 15,
              }}>
              <Touch
                onPress={() => this.props.handleBarcode()}
                style={[styles.button, {marginRight: 15}]}>
                <Text style={{color: '#ffffff', fontSize: 18}}>输入条码</Text>
              </Touch>
              <Touch onPress={this.props.clearList} style={styles.button}>
                <Text style={{color: '#ffffff', fontSize: 18}}>重新开始</Text>
              </Touch>
            </View>
            <View style={{height: 50, backgroundColor: '#333'}} />
          </View>
        </View>
      </Layout>
    );
  }
}

const styles = {
  crImg: {
    width: width * 0.25 * 0.9,
    height: width * 0.25 * 0.8,
  },
  cltLine: {
    height: 10,
    borderTopWidth: 2,
    borderTopColor: '#cccccc',
  },
  cltScroll: {
    flex: 1,
    overflow: 'hidden',
    paddingLeft: 20,
  },
  cltText: {
    textAlign: 'center',
    fontSize: 22,
    color: colors.text,
  },
  cltFirst: {
    width: width * 0.03,
  },
  clTop: {
    height: 76,
    flexDirection: 'row',
    alignItems: 'center',
    borderBottomWidth: 20,
    borderBottomColor: '#DDDDDD',
    paddingLeft: 20,
    paddingTop: 5,
  },
  cont: {
    height: 702,
    backgroundColor: '#333',
    flexDirection: 'row',
    position: 'relative',
  },
  contLeft: {
    flex: 7,
    overflow: 'hidden',
    backgroundColor: '#2E2E2E',
    position: 'relative',
    marginRight: 10,
  },
  pagination: {
    flex: 1,
    backgroundColor: '#fff',
    justifyContent: 'center',
    alignItems: 'center',
    paddingLeft: 5,
    paddingRight: 5,
  },
  contRight: {
    flex: 3,
    borderRadius: 3,
    backgroundColor: '#2E2E2E',
  },
  amount: {
    flex: 1,
    fontSize: 16,
    color: '#ff8900',
    textAlign: 'right',
  },
  amountLabel: {
    fontSize: 16,
  },
  btnRow: {
    flexDirection: 'row',
    marginTop: 15,
  },
  bagButton: {
    height: 44,
    marginLeft: 30,
    marginTop: 10,
    marginBottom: 15,
    backgroundColor: '#00c670',
    justifyContent: 'center',
    alignItems: 'center',
  },
  button: {
    flex: 1,
    height: 46,
    backgroundColor: '#106C9F',
    justifyContent: 'center',
    alignItems: 'center',
  },
  clearBtn: {
    alignSelf: 'center',
    marginTop: 20,
    width: 150,
    height: 40,
    borderWidth: 1,
    borderColor: colors.bg,
    justifyContent: 'center',
    alignItems: 'center',
  },
  infoView: {
    flexDirection: 'row',
    marginHorizontal: 30,
  },
  infoText: {
    fontSize: 22,
    color: '#000000',
  },
};

export default CounterMixins(HomePage);
