import React, {Component} from 'react';
import {View, Text, Image, Dimensions} from 'react-native';
import AsyncStorage from '@react-native-community/async-storage';
import {connect} from 'react-redux';
// import RtcEngine from 'react-native-agora';
import Touch from '../components/Touch';
import PhoneModal from '../components/PhoneModal';
import VerifyCodeModal from '../components/VerifyCodeModal';
import OrderDetailsModal from '../components/OrderDetailsModal';
import delay from '../utils/delay';
import Speech from '../utils/Speech';
import WxFacepay from '../utils/WxFacepay';
import phone from '../assets/Vertical/phone.png';
import {onTalkCall, leaveTalkCall} from '../utils/agora';

const {width} = Dimensions.get('screen');

class FacePage extends Component {
  state = {
    phoneModal: false, // 显示输入电话号码弹窗
    verifyCodeModal: false, // 显示输入验证码弹窗
    orderDetailsModal: false, // 显示订单详情弹窗
    goodsArr: [],
    talkCall: 2, // 0请求通话，1通话中，2，已挂断通话，待机状态
    contact: '',
    storeName: '',
    customerPhone: '',
    current: 1,
    tip: '',
    tipsModal: false,
  };

  async componentWillMount() {
    this.storeKey = await AsyncStorage.getItem('KEY');
    let contact = await AsyncStorage.getItem('CONTACT');
    let storeName = await AsyncStorage.getItem('NAME');
    this.setState({
      contact,
      storeName,
    });
    if (!this.init) {
      this.init = await WxFacepay.init();
    }
  }

  async componentDidMount() {
    this.listen();
  }

  onSubmit = async _phone => {
    const res = await this.props.dispatch({
      type: 'store/sendsms',
      phone: _phone,
    });
    if (res.code === 1) {
      if (/^\d+$/.test(res.msg)) {
        Speech.speak(res.msg.split('').join(' '));
      } else {
        Speech.speak('请输入验证码');
      }
      this.phone = _phone;
      this.setState({
        phoneModal: false,
        verifyCodeModal: true,
      });
    } else {
      Speech.speak(res.msg);
    }
  };

  onCodeSubmit = async code => {
    const res = await this.props.dispatch({
      type: 'store/verifysms',
      code,
      phone: this.phone,
      userId: this.userId,
    });
    if (res.code === 1) {
      this.setState({
        verifyCodeModal: false,
      });
      const ret = await this.props.dispatch({
        type: 'store/wxdoor',
        userId: res.data,
      });
      this.handleDoorLogin(ret);
    } else {
      Speech.speak(res.msg);
    }
  };

  // handleClose = () => {
  //   this.setState({
  //     phoneModal: false,
  //   });
  // };
  //
  // handleCodeClose = () => {
  //   this.setState({
  //     verifyCodeModal: false,
  //   });
  // };

  handleOrderClose = () => {
    this.setState({
      orderDetailsModal: false,
    });
  };

  listen = async () => {
    try {
      while (!window.socket) {
        await delay(1000);
      }
      if (!window.socket.hasListeners('doorLogin')) {
        // 扫码验证成功
        window.socket.on('doorLogin', this.handleDoorLogin);
      }
      if (!window.socket.hasListeners('scale')) {
        // 重力感应变化
        window.socket.on('scale', this.handleScaleChange);
      }
      if (!window.socket.hasListeners('talkCall')) {
        // 语音通话中
        window.socket.on('talkCall', this.handleTalkCall);
      }
      if (!window.socket.hasListeners('talkLeave')) {
        // 断开语音通话
        window.socket.on('talkLeave', this.leaveC);
      }
    } catch (e) {
      console.log(e);
    }
  };

  handleTalkCall = async () => {
    try {
      // 加入语音通话
      clearInterval(this.noTalkCall);
      clearInterval(this.callTimeout);
      const {data} = await this.props.dispatch({
        type: 'agora/agora',
      });
      await onTalkCall(data);
      await this.setState({
        talkCall: 1,
      });
    } catch (e) {
      console.log(e);
    }
  };

  leaveC = async () => {
    try {
      clearInterval(this.noTalkCall);
      clearInterval(this.callTimeout);
      await leaveTalkCall;
      // if (this.engine) {
      //   await this.engine.leaveChannel();
      // }
      await this.props.dispatch({
        type: 'agora/talkLeave',
      });
      this.setState({
        talkCall: 2,
      });
    } catch (e) {
      console.log(e);
    }
  };

  // device 代表当前打开的门
  handleScaleChange = async ({count}) => {
    if (count === -1) {
      // 重力感应开始识别
      this.wechatFace();
    } else if (count === 0) {
      // 重力感应归零
      this.leaveC();
      this.setState({
        orderDetailsModal: false,
        phoneModal: false,
        verifyCodeModal: false,
        current: 1,
        tipsModal: false,
        tip: '',
      });
    }
  };

  handleDoorLogin = async ret => {
    if (ret) {
      if (ret.code < 0 || ret.code === 401) {
        // 未授权，提示用户扫码验证
        let tipText = ret.msg;
        Speech.speak(tipText);
        this.userId = ret.userId;
        this.setState({tip: tipText, tipsModal: true});
        if (ret.code === 401) {
          // 需要验证手机号
          this.setState({
            phoneModal: true,
          });
        } else if (ret.orders && ret.orders.length > 0) {
          let goodsArr = [];
          ret.orders.map(v1 => {
            v1.goods.map(v2 => {
              goodsArr.push(v2);
            });
          });
          this.setState({
            orderDetailsModal: true,
            goodsArr,
            customerPhone: ret.phone || '0000',
            current: 1,
          });
        }
      } else if (ret.msg) {
        let tipText = ret.msg.replace(/扫码/g, '人脸识别');
        Speech.speak(tipText);
        if (ret.code !== 1) {
          this.setState({tip: tipText, tipsModal: true});
        }
      }
    } else {
      Speech.speak('正在重新识别，请靠中间站稳');
    }
  };

  authinfo = async () => {
    const rawdata = await WxFacepay.rawdata();
    const {data} = await this.props.dispatch({
      type: 'goods/faceinfo',
      rawdata,
    });
    return data;
  };

  // 微信人脸身份识别
  wechatFace = async () => {
    const {orderDetailsModal, tipsModal} = this.state;
    if (orderDetailsModal || tipsModal) {
      return;
    } // 出现订单弹窗，不做人脸识别
    const tipText = '正在人脸识别，请看向屏幕，靠中间站稳';
    Speech.speak(tipText);
    // this.setState({tip: tipText, tipsModal: true});
    let auth = (await this.authinfo()) || {};
    if (
      auth.return_code === 'SUCCESS' ||
      (auth.code === 1 && auth.data.bizCode === '0000')
    ) {
      if (auth.data) {
        auth = auth.data;
      }
      const params = {
        appid: auth.appid || auth.subAppId,
        mch_id: auth.mch_id || auth.subMchId,
        store_id: this.storeKey,
        authinfo: auth.authinfo || auth.authInfo,
        face_authtype: 'FACEID-ONCE',
        ask_unionid: 1,
      };
      let res = (await WxFacepay.faceinfo(params)) || {};
      if (window.socket) {
        window.socket.connect();
      } // 返回结果，立即重新连接socket
      if (!res.openid) {
        return;
      } // 没识别到人脸不开门
      if (res.sub_openid) {
        res.openid = res.sub_openid;
      }
      const ret = await this.props.dispatch({
        type: 'store/wxdoor',
        openid: res.openid,
        wxtoken: res.token,
        nickname: res.nickname,
      });
      this.handleDoorLogin(ret);
    }
  };

  // 语音通话请求
  onCall = async () => {
    const {talkCall} = this.state;
    if (talkCall === 2) {
      Speech.speak('正在接通中请稍候');
      this.talkCall();
      clearInterval(this.noTalkCall);
      this.noTalkCall = setInterval(() => this.talkCall(), 10000);
      this.setState({
        talkCall: 0,
      });
      clearInterval(this.callTimeout);
      this.callTimeout = setTimeout(() => {
        clearInterval(this.noTalkCall);
        this.setState({
          talkCall: 2,
        });
      }, 30000);
    }
  };

  talkCall = () => {
    this.props.dispatch({
      type: 'agora/talkCall',
    });
  };

  dropUp = () => {
    let {current} = this.state;
    if (current > 1) {
      this.setState({
        current: --current,
      });
    }
  };

  dropDown = goodsLength => {
    let {current} = this.state;
    if (current < goodsLength) {
      this.setState({
        current: ++current,
      });
    }
  };

  render() {
    const {
      verifyCodeModal,
      phoneModal,
      orderDetailsModal,
      goodsArr,
      talkCall,
      storeName,
      contact,
      customerPhone,
      current,
      tip,
      tipsModal,
    } = this.state;
    let {dispatch} = this.props;
    return (
      <View style={styles.content}>
        <PhoneModal
          visible={phoneModal}
          transparent
          // maskClosable
          // onClose={this.handleClose}
          // onRequestClose={this.handleClose}
          onCall={this.onCall}
          onSubmit={this.onSubmit}
        />
        <VerifyCodeModal
          visible={verifyCodeModal}
          transparent
          // maskClosable
          // onClose={this.handleCodeClose}
          // onRequestClose={this.handleCodeClose}
          onCall={this.onCall}
          onSubmit={this.onCodeSubmit}
        />
        <OrderDetailsModal
          visible={orderDetailsModal}
          transparent
          maskClosable
          onClose={this.handleOrderClose}
          onRequestClose={this.handleOrderClose}
          onCall={this.onCall}
          dropUp={this.dropUp}
          dropDown={this.dropDown}
          goodsArr={goodsArr}
          dispatch={dispatch}
          talkCall={talkCall}
          customerPhone={customerPhone}
          current={current}
        />
        <View style={styles.header}>
          <View style={styles.title}>
            <View style={styles.left}>
              <Image
                source={require('../assets/logo2.png')}
                style={styles.img}
              />
              <Text style={styles.text}>{storeName}</Text>
            </View>
            <View style={styles.right}>
              <Text style={styles.text}>{contact}</Text>
              <Image style={styles.phone} source={phone} />
            </View>
          </View>
          <View style={styles.headline}>
            <Text style={styles.headTitle}>刷脸开门系统</Text>
          </View>
        </View>
        <View style={styles.face}>
          <View style={styles.faceRecogn}>
            <Touch
              style={styles.faceGif}
              onPress={() => this.wechatFace()}
              feedback={false}>
              <Image
                source={require('../assets/Vertical/face.gif')}
                style={{flex: 1, width}}
              />
            </Touch>
            {tipsModal && tip && (
              <View style={styles.modal}>
                <Touch
                  onPress={() => this.setState({tipsModal: false, tip: ''})}
                  feedback={false}
                  style={styles.tips}>
                  <Text style={styles.tipText}>{tip}</Text>
                </Touch>
                <Touch
                  onPress={this.onCall}
                  feedback={false}
                  style={styles.callTouch}>
                  <View style={styles.callTips}>
                    <Text style={styles.callTipsText}>呼叫客服</Text>
                    <Image
                      source={require('../assets/up.png')}
                      style={styles.callTipsImg}
                    />
                  </View>
                </Touch>
              </View>
            )}
          </View>
          <Touch
            onPress={() => this.wechatFace()}
            style={styles.btnCome}
            feedback={false}>
            <View style={styles.click}>
              <Image
                source={require('../assets/wxpay.png')}
                style={styles.wxpay}
              />
              <Text style={styles.clickText}>点击进入</Text>
              <Image source={require('../assets/up.png')} style={styles.up} />
              <Text style={styles.clickText}>刷脸开门</Text>
            </View>
          </Touch>
        </View>
        {talkCall === 1 ? (
          <View style={styles.onCall}>
            <Image
              source={require('../assets/call.gif')}
              style={styles.callGif}
            />
            <Text style={styles.onCallText}>正在语音通话中</Text>
          </View>
        ) : talkCall === 0 ? (
          <View style={styles.onCall}>
            <Image
              source={require('../assets/call.gif')}
              style={styles.callGif}
            />
            <Text style={styles.onCallText}>正在接通中请稍候...</Text>
          </View>
        ) : (
          <Touch onPress={this.onCall} style={styles.footer} feedback={false}>
            <View style={styles.call}>
              <Image
                source={require('../assets/call.gif')}
                style={styles.callGif}
              />
              <Text style={styles.callText}>呼叫客服</Text>
            </View>
          </Touch>
        )}
      </View>
    );
  }
}

const styles = {
  content: {
    flex: 1,
    alignItems: 'center',
    backgroundColor: '#fff',
  },
  header: {
    flex: 0.2,
    // backgroundColor: '#00CD66',
    backgroundColor: 'rgb(0,205,102)',
    width: '100%',
    flexDirection: 'column',
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: 30,
    marginRight: 30,
    marginTop: 10,
  },
  headline: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    flex: 1,
    marginBottom: 20,
  },
  headTitle: {
    fontSize: 60,
    color: '#fff',
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
  },
  img: {
    width: 60,
    height: 60,
    marginRight: 10,
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: 40,
  },
  face: {
    flex: 0.6,
    width: '100%',
    flexDirection: 'column',
    alignItems: 'center',
    justifyContent: 'space-around',
  },
  faceRecogn: {
    flex: 0.7,
  },
  faceGif: {
    // flex: 0.7,
    position: 'relative',
    zIndex: 2,
  },
  btnCome: {
    flex: 0.15,
    // backgroundColor: '#00CD66',
    backgroundColor: 'rgb(0,205,102)',
    width: '80%',
    borderRadius: 30,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    elevation: 2,
  },
  click: {
    flexDirection: 'row',
  },
  clickText: {
    fontSize: 50,
    color: '#fff',
    marginTop: 25,
  },
  wxpay: {
    width: 72,
    height: 65,
    marginTop: 30,
    marginRight: 10,
  },
  up: {
    width: 100,
    height: 120,
  },
  phone: {
    width: 40,
    height: 40,
    marginRight: 10,
    resizeMode: 'contain',
  },
  footer: {
    flex: 0.2,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68, 197, 114)',
  },
  call: {
    felx: 1,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  callGif: {
    width: 350,
    height: 240,
    marginLeft: -120,
  },
  callText: {
    fontSize: 70,
    color: '#fff',
    marginLeft: -50,
  },
  onCall: {
    flex: 0.2,
    width: '100%',
    // backgroundColor: '#44c571',
    backgroundColor: 'rgb(68, 197, 114)',
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  onCallText: {
    fontSize: 70,
    color: '#fff',
    marginLeft: -70,
  },
  modal: {
    // flex: 0.2,
    marginTop: '30%',
    width: '100%',
    height: 200,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    position: 'absolute',
    zIndex: 999,
  },
  tips: {
    flexDirection: 'row',
    backgroundColor: '#FC4000',
    width: '70%',
    // height: '18%',
    height: 200,
    justifyContent: 'center',
    alignItems: 'center',
    marginRight: 5,
  },
  tipText: {
    fontSize: 40,
    color: '#fff',
    textAlign: 'center',
    paddingTop: 40,
    paddingBottom: 40,
    paddingLeft: 5,
    paddingRight: 5,
  },
  callTouch: {
    width: '30%',
    // height: '18%',
    height: 200,
    marginLeft: 5,
    backgroundColor: '#FC4000',
  },
  callTips: {
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
    // backgroundColor: '#FC4000',
    // width: '30%',
    // height: '18%',
    // marginLeft: 5,
  },
  callTipsText: {
    fontSize: 40,
    color: '#fff',
    textAlign: 'center',
    paddingTop: 70,
    // paddingBottom: 40,
    paddingLeft: 10,
    paddingRight: 10,
  },
  callTipsImg: {
    width: 80,
    height: 60,
  },
};

export default connect(({store}) => ({store}))(FacePage);
