import React, {Component} from 'react';
import {View, Dimensions} from 'react-native';
import QRCode from 'react-native-qrcode-svg';
import io from 'socket.io-client';
import axios from 'axios';
import {counterLogin} from '../utils/authLogin';
import config from '../utils/config';
import HomeLayout from '../components/HomeLayout';
import {setSpText, scaleSize} from '../utils/screen';

class AuthPage extends Component {
  state = {
    isLandscape: false,
  };

  async componentDidMount() {
    const {width, height} = Dimensions.get('window');
    this.setState({isLandscape: width > height});
    this.socket = io(axios.defaults.baseURL);
    this.socket.on('storeAuth', this.handleLogin);
    this.socket.on('connect', () => {
      this.setState({socket: this.socket.id});
    });
    this.socket.on('disconnect', () => {
      this.socket.connect();
    });
  }

  handleLogin = async values => {
    this.setState({loading: true});
    values.login = values.device;
    await counterLogin(values);
  };

  render() {
    const {socket, isLandscape} = this.state;
    return (
      <HomeLayout>
        <View style={styles.qrcode}>
          <QRCode
            size={isLandscape ? scaleSize(420) : scaleSize(700)}
            logo={require('../assets/logo.png')}
            backgroundColor="white"
            value={`${config.qrHost}/#/store-auth-${socket}`}
          />
        </View>
      </HomeLayout>
    );
  }
}

const styles = {
  qrcode: {
    padding: setSpText(10),
    backgroundColor: 'white',
    elevation: 5,
  },
};

export default AuthPage;
