import React from 'react';
import {View, Text} from 'react-native';
import Icon from 'react-native-vector-icons/Ionicons';
import MIcon from 'react-native-vector-icons/MaterialCommunityIcons';
import {colors, font} from '../utils/common';
import Touch from './Touch';
import Modal from './Modal';
import ModalStyles from './Modal/styles';

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
    width: 580,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

export default class KeyboardModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      value: '',
      clickDot: true,
    };
  }

  getKeyboard = () => {
    const rows = [];
    let items = [];
    const {dot} = this.props;
    for (let i = 1; i <= 12; i++) {
      let unit;
      if (i === 10 && !dot) {
        unit = (
          <MIcon style={styles.keyUnit} name="backspace-outline" size={60} />
        );
      } else if (i === 10 && dot) {
        unit = <Text style={styles.keyUnit}>.</Text>;
      } else if (i === 11) {
        unit = <Text style={styles.keyUnit}>0</Text>;
      } else if (i === 12) {
        unit = <Icon style={styles.keyUnit} name="md-return-left" size={60} />;
      } else {
        unit = <Text style={styles.keyUnit}>{i}</Text>;
      }
      const item = (
        <Touch style={styles.keyTouch} key={i} onPress={() => this.pressKey(i)}>
          {unit}
        </Touch>
      );
      items.push(item);
      if (i % 3 === 0) {
        rows.push(
          <View style={styles.keyRow} key={i}>
            {items}
          </View>,
        );
        items = [];
      }
    }
    return <View>{rows}</View>;
  };

  pressKey = index => {
    let {value, clickDot} = this.state;
    const {dot} = this.props;
    if (index < 10) {
      value += index;
    } else if (index === 10 && !dot) {
      value = value.substr(0, value.length - 1);
    } else if (index === 10 && dot && clickDot) {
      value += '.';
      clickDot = false;
    } else if (index === 11) {
      value += 0;
    } else if (index === 12) {
      this.props.onSubmit(value);
      this.handleClose();
      return;
    }
    this.setState({value, clickDot});
  };

  handleClose = () => {
    this.setState({value: '', clickDot: true});
    this.props.onClose();
  };

  render() {
    const {title, visible} = this.props;
    const {value} = this.state;
    return (
      <Modal
        styles={mStyles}
        visible={visible}
        transparent
        maskClosable
        onClose={this.handleClose}
        title={title}>
        <Touch
          style={{position: 'absolute', top: -65, right: 20}}
          onPress={this.handleClose}
          feedback={false}>
          <Icon size={50} name="ios-close-circle-outline" />
        </Touch>
        <View
          style={{
            width: 550,
            borderTopColor: '#cccccc',
            borderTopWidth: 1,
            paddingVertical: 20,
          }}>
          <View
            style={{
              width: 550,
              height: 70,
              justifyContent: 'center',
              position: 'relative',
            }}>
            <View
              style={{
                borderBottomWidth: 2,
                borderBottomColor: '#ddd',
                alignItems: 'center',
                marginLeft: 20,
                marginRight: 20,
              }}>
              <Text style={{color: 'gray', fontSize: 35, paddingBottom: 15}}>
                {value || ' '}
              </Text>
            </View>
            <Touch
              onPress={() => this.setState({value: '', clickDot: true})}
              style={{
                position: 'absolute',
                right: 30,
                paddingLeft: 10,
                paddingRight: 10,
              }}>
              <Icon name="ios-close" size={50} color="#D1D1D1" />
            </Touch>
          </View>
          {this.getKeyboard()}
        </View>
      </Modal>
    );
  }
}

const styles = {
  keyRow: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: 15,
  },
  keyTouch: {
    width: 80,
    height: 80,
    justifyContent: 'center',
    alignItems: 'center',
    borderWidth: 1,
    borderColor: '#cccccc',
    borderRadius: 5,
    marginHorizontal: 15,
  },
  keyUnit: {
    // fontSize: font.textActive,
    fontSize: 25,
    color: colors.text,
  },
};
