import {Dimensions, PixelRatio} from 'react-native';

/**
 * 屏幕工具类
 * ui设计基准,iphone 6
 * width:750
 * height:1334
 */

/*
 设备的像素密度，例如：
 PixelRatio.get() === 1          mdpi Android 设备 (160 dpi)
 PixelRatio.get() === 1.5        hdpi Android 设备 (240 dpi)
 PixelRatio.get() === 2          iPhone 4, 4S,iPhone 5, 5c, 5s,iPhone 6,xhdpi Android 设备 (320 dpi)
 PixelRatio.get() === 3          iPhone 6 plus , xxhdpi Android 设备 (480 dpi)
 PixelRatio.get() === 3.5        Nexus 6
 */
const {width: _width, height: _height} = Dimensions.get('window'); //获取设备的宽度、高度
const fontScale = PixelRatio.getFontScale(); //返回字体大小缩放比例
// let pixelRatio = PixelRatio.get(); //当前设备的像素密度
// const defaultPixel = 2; //iphone6的像素密度
//px转换成dp
// const w2 = 1080 / defaultPixel;
// const h2 = 1920 / defaultPixel;
const w2 = 1080;
const h2 = 1920;
const scale = Math.min(_height / h2, _width / w2); //获取缩放比例
//缩放比例
const _scaleWidth = _width / w2;
const _scaleHeight = _height / h2;

/**
 * 设置text为sp
 * @param size sp
 * return number dp
 */
export function setSpText(size: number) {
  // size = Math.round(((size * scale + 0.5) * pixelRatio) / fontScale);
  size = Math.round((size * scale + 0.5) / fontScale);
  // return size / defaultPixel;
  return size;
}

/**
 * 屏幕适配,缩放size , 默认根据宽度适配，纵向也可以使用此方法
 * 横向的尺寸直接使用此方法
 * 如：width ,paddingHorizontal ,paddingLeft ,paddingRight ,marginHorizontal ,marginLeft ,marginRight
 * @param size 设计图的尺寸
 * @returns {number}
 */
export function scaleSize(size: Number) {
  size = Math.round(size * _scaleWidth + 0.5);
  return size;
}

/**
 * 屏幕适配 , 纵向的尺寸使用此方法应该会更趋近于设计稿
 * 如：height ,paddingVertical ,paddingTop ,paddingBottom ,marginVertical ,marginTop ,marginBottom
 * @param size 设计图的尺寸
 * @returns {number}
 */
export function scaleHeight(size: Number) {
  size = Math.round(size * _scaleHeight + 0.5);
  return size;
}

export const w = 1;
export const h = 1;
export const width = _width * w;
export const height = _height * h;
export const left = _width * (0.5 - w / 2);
export const top = _height * (0.5 - h / 2);

export default {
  w,
  h,
  width,
  height,
  left,
  top,
};
