import React from 'react';
import io from 'socket.io-client';
import {View, Text} from 'react-native';
import Touch from '../../components/Touch';
import {height, width} from '../../utils/screen';
import {host} from '../../utils/config';

export default class SocketPage extends React.Component {
  state = {
    msg: '',
  };

  componentDidMount() {
    this.socket = io(host);
    this.socket.on('test', msg => {
      this.setState({msg});
    });
  }

  sayHello = () => {
    this.socket.emit('test', 'Hello');
  };

  render() {
    return (
      <View
        style={{
          width,
          height,
          backgroundColor: 'rgba(255,255,255,.5)',
          justifyContent: 'center',
          alignItems: 'center',
        }}>
        <Touch onPress={this.sayHello}>
          <Text style={{fontSize: 80}}>Click here to say hello.</Text>
        </Touch>
        <Text style={{fontSize: 60}}>
          Receive from server: {this.state.msg}
        </Text>
      </View>
    );
  }
}
