import React, {Component} from 'react';
import {Modal, View, Text, Image, TextInput} from 'react-native';
import Icon from 'react-native-vector-icons/Ionicons';
import MIcon from 'react-native-vector-icons/MaterialCommunityIcons';
import ModalStyles from './Modal/styles';
import {colors, font} from '../utils/common';
import Touch from './Touch';

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
    // width: 380,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

class PhoneModal extends Component {
  state = {
    value: '',
  };

  getKeyboard = () => {
    const rows = [];
    let items = [];
    for (let i = 1; i <= 9; i++) {
      let unit;
      unit = <Text style={styles.keyUnit}>{i}</Text>;
      const item = (
        <Touch style={styles.keyTouch} key={i} onPress={() => this.pressKey(i)}>
          {unit}
        </Touch>
      );
      items.push(item);
      if (i % 3 === 0) {
        rows.push(
          <View style={styles.keyRow} key={i}>
            {items}
          </View>,
        );
        items = [];
      }
    }
    return <View style={styles.NumberTop}>{rows}</View>;
  };

  pressKey = index => {
    let {value} = this.state;
    const {onSubmit} = this.props;
    if (index < 10) {
      value += index;
    } else if (index === 11) {
      value = value.substr(0, value.length - 1);
    } else if (index === 12) {
      this.setState({value: ''});
      onSubmit(value);
      return;
    }
    this.setState({value});
  };

  render() {
    const {onClose, ...props} = this.props;
    const {value} = this.state;
    return (
      <Modal styles={mStyles} {...props}>
        <View style={styles.modal}>
          <View style={styles.header}>
            <View style={styles.title}>
              <View style={styles.left}>
                <Image
                  source={require('../assets/logo.png')}
                  style={styles.img}
                />
                <Text style={styles.text}>安全验证手机号</Text>
              </View>
              <View style={styles.right}>
                <Touch onPress={() => onClose()}>
                  <Icon name="md-close" color={'#FFFFFF'} size={50} />
                </Touch>
              </View>
            </View>
            <View style={styles.image}>
              <Image
                source={require('../assets/logo2.png')}
                style={styles.logo}
              />
            </View>
          </View>
          <View style={styles.container}>
            <Text style={{color: 'red', fontSize: 45, marginBottom: 10}}>
              请输入接收验证码的手机号
            </Text>
            <View
              style={{
                flexDirection: 'row',
                justifyContent: 'center',
                alignItems: 'center',
              }}>
              <TextInput
                style={{
                  fontSize: 35,
                  width: '80%',
                  textAlign: 'center',
                  padding: 30,
                }}
                placeholder="安全输入不留痕迹"
                placeholderTextColor="lightgray"
                editable={false}
                value={value}
              />
              <Touch
                onPress={() => this.setState({value: ''})}
                feddback={false}>
                <Icon name="md-close" color={'#DCDCDC'} size={50} />
              </Touch>
            </View>
          </View>
          <View style={styles.footer}>
            <View style={styles.footerLeft}>
              {this.getKeyboard()}
              <View style={styles.keyRowBottom}>
                <Touch
                  style={styles.keyBottomTouch}
                  onPress={() => this.pressKey(0)}>
                  <Text style={styles.keyUnit}>0</Text>
                </Touch>
              </View>
            </View>
            <View style={styles.footerRight}>
              <View style={styles.keyRowClose}>
                <Touch
                  style={styles.keyTouchClose}
                  onPress={() => this.pressKey(11)}>
                  <MIcon
                    style={styles.keyUnit}
                    name="backspace-outline"
                    size={60}
                  />
                </Touch>
              </View>
              <View style={styles.keyRowSure}>
                {/* <Touch style={styles.keyTouchSure} onPress={() => this.pressKey(12)}>*/}
                {/*  <Text style={styles.keyUnitClose}>确定</Text>*/}
                {/* </Touch>*/}
                {value.length < 1 ? (
                  <View style={styles.keyTouchSure}>
                    <Text style={styles.keyUnitClose}>确定</Text>
                  </View>
                ) : (
                  <Touch
                    style={styles.keyTouchOnSure}
                    onPress={() => this.pressKey(12)}>
                    <Text style={styles.keyUnitClose}>确定</Text>
                  </Touch>
                )}
              </View>
            </View>
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  modal: {
    height: '86%',
    width: '90%',
    marginLeft: '5%',
    marginTop: '10%',
    borderRadius: 20,
    backgroundColor: '#cccccc',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  header: {
    flex: 0.4,
    backgroundColor: '#00CD66',
    width: '100%',
    flexDirection: 'column',
    borderTopRightRadius: 10,
    borderTopLeftRadius: 10,
  },
  title: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginLeft: 30,
    marginRight: 30,
    marginTop: 10,
  },
  left: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  right: {
    flexDirection: 'row-reverse',
    alignItems: 'center',
  },
  img: {
    width: 80,
    height: 80,
    marginRight: 10,
    resizeMode: 'contain',
  },
  image: {
    flex: 1,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  logo: {
    width: 150,
    height: 150,
    resizeMode: 'contain',
  },
  text: {
    color: '#FFFFFF',
    fontSize: 30,
  },
  container: {
    flex: 0.2,
    backgroundColor: '#FFFFFF',
    width: '100%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  footer: {
    flex: 0.4,
    width: '100%',
    flexDirection: 'row',
    backgroundColor: '#F5F5F5',
    borderBottomLeftRadius: 10,
    borderBottomRightRadius: 10,
  },
  footerLeft: {
    width: '75%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  NumberTop: {
    flex: 0.8,
  },
  keyRow: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: 10,
    marginLeft: 20,
    marginRight: 10,
    flex: 0.33,
  },
  keyRowBottom: {
    width: '100%',
    flexDirection: 'row',
    justifyContent: 'center',
    marginTop: 10,
    marginLeft: 20,
    marginRight: 10,
    marginBottom: 10,
    flex: 0.2,
  },
  keyBottomTouch: {
    width: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#FFFFFF',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyTouch: {
    width: '33%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#FFFFFF',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyUnit: {
    fontSize: 50,
    color: colors.text,
  },
  footerRight: {
    width: '25%',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
  },
  keyRowClose: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginLeft: 10,
    marginTop: 10,
    marginRight: 5,
    flex: 0.25,
  },
  keyTouchClose: {
    width: '90%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#FFFFFF',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyRowSure: {
    flexDirection: 'row',
    justifyContent: 'center',
    marginLeft: 10,
    marginTop: 10,
    marginBottom: 10,
    marginRight: 5,
    flex: 0.75,
  },
  keyTouchSure: {
    width: '90%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#76EEC6',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyTouchOnSure: {
    width: '90%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#00CD66',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  keyUnitClose: {
    fontSize: 50,
    color: '#FFFFFF',
  },
};

export default PhoneModal;
