import React, {Component} from 'react';
import {Modal, View, Text, Image, Dimensions} from 'react-native';
import QRCode from 'react-native-qrcode-svg';
import ModalStyles from './Modal/styles';
import {font} from '../utils/common';
import {scaleSize, setSpText} from '../utils/screen';
import Touch from './Touch';

const mStyles = {
  ...ModalStyles,
  innerContainer: {
    ...ModalStyles.innerContainer,
  },
  header: {
    ...ModalStyles.header,
    fontSize: font.title,
  },
};

const {width, height} = Dimensions.get('window');

class TipsModal extends Component {
  render() {
    let {
      tip,
      title,
      leftText,
      contentText,
      rightText,
      leftTouch,
      contentTouch,
      rightTouch,
      faceType,
      qrCode,
      onMaskPress,
      ...props
    } = this.props;
    let flag = true;
    if (contentText === '') {
      flag = false;
    }
    if (faceType === 'alipay') {
      styles.header = {...styles.header, backgroundColor: '#1b7dc7'};
      styles.left = {
        ...styles.left,
        backgroundColor: '#1b7dc7',
      };
      styles.lefts = {
        ...styles.lefts,
        backgroundColor: '#1b7dc7',
      };
      styles.reset = {
        ...styles.reset,
        color: '#1b7dc7',
      };
    }
    return (
      <Modal styles={mStyles} {...props}>
        <View style={styles.modalBackgroundStyle}>
          <Touch
            style={styles.mask}
            onPress={() => onMaskPress && onMaskPress()}>
            <View />
          </Touch>
          <View style={styles.modal}>
            <View style={styles.header}>
              <Image
                source={
                  faceType === 'wxpay'
                    ? require('../assets/wxpay.png')
                    : require('../assets/Vertical/alipay01.png')
                }
                style={styles.image}
                tintColor="white"
              />
              <Text style={styles.title}>{title}</Text>
            </View>
            <View style={styles.container}>
              {qrCode && (
                <View style={styles.qrcode}>
                  <QRCode
                    logoSize={scaleSize(80)}
                    // logoBackgroundColor="#fc4000"
                    logo={require('../assets/logo2.png')}
                    size={scaleSize(360)}
                    value={qrCode}
                  />
                </View>
              )}
              <Text
                ellipsizeMode="tail"
                numberOfLines={qrCode ? 1 : 3}
                style={styles.tip}>
                {tip}
              </Text>
            </View>
            {!qrCode && (
              <View style={styles.footer}>
                <Touch
                  style={flag ? styles.left : styles.lefts}
                  onPress={() => leftTouch()}>
                  <Text style={styles.call}>{leftText}</Text>
                </Touch>
                <Touch
                  style={flag ? styles.content : styles.contents}
                  onPress={() => contentTouch()}>
                  <Text style={styles.reset}>{contentText}</Text>
                </Touch>
                <Touch
                  style={flag ? styles.right : styles.rights}
                  onPress={() => rightTouch()}>
                  <Text style={styles.reset}>{rightText}</Text>
                </Touch>
              </View>
            )}
          </View>
        </View>
      </Modal>
    );
  }
}

const styles = {
  modalBackgroundStyle: {
    flex: 1,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
  },
  mask: {
    width,
    height,
    position: 'absolute',
  },
  modal: {
    height: '40%',
    width: '80%',
    marginLeft: '10%',
    marginTop: '40%',
    borderRadius: 20,
    backgroundColor: '#fff',
    flexDirection: 'column',
  },
  header: {
    flex: 0.2,
    flexDirection: 'row',
    alignItems: 'center',
    backgroundColor: '#2BA245',
    borderTopLeftRadius: 20,
    borderTopRightRadius: 20,
  },
  qrcode: {
    marginTop: scaleSize(150),
    marginBottom: scaleSize(10),
  },
  image: {
    width: scaleSize(60),
    height: scaleSize(60),
    marginLeft: scaleSize(50),
    marginRight: scaleSize(30),
  },
  title: {
    fontSize: setSpText(45),
    color: '#fff',
  },
  container: {
    flex: 0.6,
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
    padding: scaleSize(60),
  },
  tip: {
    textAlign: 'center',
    fontSize: setSpText(50),
  },
  footer: {
    flex: 0.2,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  left: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    width: '33.3%',
    height: '100%',
    borderBottomLeftRadius: 15,
    backgroundColor: '#2BA245',
  },
  lefts: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    width: '50%',
    height: '100%',
    borderBottomLeftRadius: 15,
    backgroundColor: '#2BA245',
  },
  content: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    width: '33.3%',
    height: '100%',
    backgroundColor: '#f0f0f0',
  },
  contents: {
    display: 'none',
  },
  call: {
    fontSize: setSpText(45),
    color: '#fff',
  },
  right: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    width: '33.3%',
    height: '100%',
    backgroundColor: '#ced2cf',
    borderBottomRightRadius: 15,
  },
  rights: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    width: '50%',
    height: '100%',
    backgroundColor: '#ced2cf',
    borderBottomRightRadius: 15,
  },
  reset: {
    fontSize: setSpText(45),
    color: '#2BA245',
  },
};

export default TipsModal;
