/**
 * 简单防抖
 * @param {Function} 防抖回调函数
 * @param {Number} 触发时间
 */
export function simpleDebounce(fn, delay = 500) {
  let timer = null;
  return function() {
    if (timer) {
      clearTimeout(timer);
    }
    timer = setTimeout(() => {
      fn.apply(this, arguments);

      timer = null;
    }, delay);
  };
}
